/*
 * Decompiled with CFR 0.152.
 */
package net.joala.expression.library.net;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import net.joala.expression.AbstractExpression;
import net.joala.expression.ExpressionEvaluationException;
import net.joala.matcher.net.KnownHost;
import net.joala.time.Timeout;
import net.joala.time.TimeoutImpl;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;

public class UriStatusCodeExpression
extends AbstractExpression<Integer> {
    private static final Timeout DEFAULT_TIMEOUT = new TimeoutImpl(10L, TimeUnit.SECONDS);
    private final Timeout timeout;
    private final URI uri;

    public UriStatusCodeExpression(@Nonnull URI uri) {
        this(DEFAULT_TIMEOUT, uri);
    }

    public UriStatusCodeExpression(@Nonnull Timeout timeout, @Nonnull URI uri) {
        super(String.format("Retrieve status code from URI %s", uri));
        this.timeout = timeout;
        this.uri = uri;
    }

    @Nonnull
    public Integer get() {
        String host = this.uri.getHost();
        Preconditions.checkState((boolean)KnownHost.knownHost().matches((Object)host), (String)"Host %s from URI %s is unknown.", (Object[])new Object[]{host, this.uri});
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            HttpParams httpParams = httpClient.getParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)((int)this.timeout.in(TimeUnit.MILLISECONDS)));
            HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)((int)this.timeout.in(TimeUnit.MILLISECONDS)));
            HttpHead httpHead = new HttpHead(this.uri);
            try {
                HttpResponse response = httpClient.execute((HttpUriRequest)httpHead);
                HttpEntity httpEntity = response.getEntity();
                StatusLine statusLine = response.getStatusLine();
                int statusCode = statusLine.getStatusCode();
                if (httpEntity != null) {
                    EntityUtils.consume((HttpEntity)httpEntity);
                }
                Integer n = statusCode;
                return n;
            }
            catch (IOException e) {
                throw new ExpressionEvaluationException(String.format("Failure reading from URI %s.", this.uri), (Throwable)e);
            }
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }
}

