/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.db.schema.action;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.jmatrix.db.common.ClassLogFactory;
import net.jmatrix.db.schema.DBM;
import net.jmatrix.db.schema.DBMException;
import net.jmatrix.db.schema.DiskVersion;
import net.jmatrix.db.schema.SQLStatement;
import net.jmatrix.db.schema.action.AbstractAction;
import org.slf4j.Logger;

public class ApplyAction
extends AbstractAction {
    private static Logger log = ClassLogFactory.getLog();
    DiskVersion version = null;

    public ApplyAction(DBM d, DiskVersion dv) {
        super(d);
        this.version = dv;
    }

    public String toString() {
        return "Apply(" + this.version.getVersion() + ")";
    }

    @Override
    public String summary() {
        StringBuilder sb = new StringBuilder();
        sb.append("Apply: DiskVersion " + this.version.getVersion() + " at " + this.version.getPath() + "\n");
        List<File> files = this.version.getApplyFiles();
        for (File f : files) {
            sb.append("          File: " + f.getName() + "\n");
        }
        return sb.toString();
    }

    @Override
    public boolean execute() throws DBMException {
        try {
            log.info(">>>>>>>>>>>>> Applying " + this.version);
            int count = 0;
            boolean versionSuccess = true;
            for (SQLStatement statement : this.version.getApplyStatements()) {
                ++count;
                boolean success = this.dbm.executeStatement(statement);
                if (success) continue;
                log.warn("Failed to execute statement " + count + " from Version " + this.version.getVersion());
                log.warn("   Path: " + statement.getFile());
                versionSuccess = false;
                break;
            }
            if (versionSuccess) {
                String rollback = this.rollbackJson();
                boolean canrollback = false;
                if (rollback != null && rollback.length() < 2000) {
                    canrollback = true;
                } else {
                    rollback = null;
                }
                this.dbm.getDBMData().setVersion(this.version.getVersion().toString(), "APPLY", this.version.getPath().getAbsolutePath(), canrollback, this.version.getChecksum(), "apply " + this.version, rollback);
            } else {
                log.warn("Not updating DBM Version, fix above errors manually.");
            }
            return versionSuccess;
        }
        catch (Exception ex) {
            throw new DBMException("Error Applying " + this.version.getVersion() + ".", ex);
        }
    }

    String rollbackJson() throws JsonProcessingException {
        List<SQLStatement> rollbackStatements = this.version.getRollbackStatements();
        ArrayList<String> sqls = new ArrayList<String>();
        if (rollbackStatements != null) {
            for (SQLStatement state : rollbackStatements) {
                sqls.add(state.getSql());
            }
        } else {
            return null;
        }
        ObjectMapper om = new ObjectMapper();
        String json = om.writeValueAsString(sqls);
        return json;
    }
}

