/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.db.schema;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.zip.CRC32;
import net.jmatrix.db.common.ClassLogFactory;
import net.jmatrix.db.common.SQLUtil;
import net.jmatrix.db.common.StreamUtil;
import net.jmatrix.db.common.Version;
import net.jmatrix.db.schema.SQLStatement;
import org.slf4j.Logger;

public class DiskVersion
implements Comparable<DiskVersion> {
    static Logger log = ClassLogFactory.getLog();
    Version version = null;
    File path = null;
    Date date = null;
    List<File> applyFiles = null;
    List<File> rollbackFiles = null;
    List<SQLStatement> applyStatements;
    List<SQLStatement> rollbackStatements;
    long checksum = -1L;

    public DiskVersion(File p) throws IOException {
        this.path = p;
        log.debug("Path name: " + this.path.getName());
        String sver = this.path.getName();
        this.version = new Version(sver);
        this.applyFiles = DiskVersion.getSQLFiles(new File(this.path, "apply"));
        this.rollbackFiles = DiskVersion.getSQLFiles(new File(this.path, "rollback"));
        if (this.applyFiles != null) {
            this.applyStatements = this.getStatmentsFromFiles(this.applyFiles);
        }
        if (this.rollbackFiles != null) {
            this.rollbackStatements = this.getStatmentsFromFiles(this.rollbackFiles);
        }
        this.updateDiskDate();
    }

    private void updateDiskDate() {
        long mtime = 0L;
        if (this.applyFiles != null) {
            for (File f : this.applyFiles) {
                if (f.lastModified() <= mtime) continue;
                mtime = f.lastModified();
            }
        }
        if (this.rollbackFiles != null) {
            for (File f : this.rollbackFiles) {
                if (f.lastModified() <= mtime) continue;
                mtime = f.lastModified();
            }
        }
        this.date = new Date(mtime);
    }

    @Override
    public int compareTo(DiskVersion o) {
        return this.version.compareTo(o.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.version + ": ");
        if (this.applyFiles != null) {
            sb.append("Apply [" + this.applyStatements.size() + " statements in " + this.applyFiles.size() + " files]");
        } else {
            sb.append("No Apply");
        }
        if (this.rollbackFiles != null) {
            sb.append(" Rollback [" + this.rollbackStatements.size() + " statements in " + this.rollbackFiles.size() + " files]");
        } else {
            sb.append(" No Rollback");
        }
        return sb.toString();
    }

    private List<SQLStatement> getStatmentsFromFiles(List<File> files) throws IOException {
        ArrayList<SQLStatement> statements = new ArrayList<SQLStatement>();
        for (File file : files) {
            log.debug("Parsing SQL file " + file);
            String sql = StreamUtil.readToString(file);
            sql = SQLUtil.stripSQLComments(sql);
            List<String> sqls = SQLUtil.splitSQL(sql, ";");
            for (String st : sqls) {
                statements.add(new SQLStatement(this, st, file));
            }
        }
        return statements;
    }

    private static List<File> getSQLFiles(File path) {
        if (path.exists() && path.canRead()) {
            File[] files = path.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().toLowerCase().endsWith(".sql") || pathname.getName().toLowerCase().endsWith(".ddl");
                }
            });
            List<File> fileList = Arrays.asList(files);
            Collections.sort(fileList);
            return fileList;
        }
        return null;
    }

    long calculateApplyChecksum() {
        if (this.applyStatements == null || this.applyStatements.size() == 0) {
            return 0L;
        }
        CRC32 crc = new CRC32();
        for (SQLStatement applystate : this.applyStatements) {
            crc.update(applystate.getSql().getBytes());
        }
        return crc.getValue();
    }

    public String getChecksum() {
        if (this.checksum == -1L) {
            this.checksum = this.calculateApplyChecksum();
        }
        return "" + this.checksum;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public File getPath() {
        return this.path;
    }

    public void setPath(File path) {
        this.path = path;
    }

    public List<File> getApplyFiles() {
        return this.applyFiles;
    }

    public void setApplyFiles(List<File> applyFiles) {
        this.applyFiles = applyFiles;
    }

    public List<File> getRollbackFiles() {
        return this.rollbackFiles;
    }

    public void setRollbackFiles(List<File> rollbackFiles) {
        this.rollbackFiles = rollbackFiles;
    }

    public List<SQLStatement> getApplyStatements() {
        return this.applyStatements;
    }

    public void setApplyStatements(List<SQLStatement> applyStatements) {
        this.applyStatements = applyStatements;
    }

    public List<SQLStatement> getRollbackStatements() {
        return this.rollbackStatements;
    }

    public void setRollbackStatements(List<SQLStatement> rollbackStatements) {
        this.rollbackStatements = rollbackStatements;
    }

    public int getApplyCount() {
        if (this.applyStatements == null) {
            return 0;
        }
        return this.applyStatements.size();
    }

    public int getRollbackCount() {
        if (this.rollbackStatements == null) {
            return 0;
        }
        return this.rollbackStatements.size();
    }

    public Date getDate() {
        return this.date;
    }
}

