/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.db.jsql.formatters;

import java.io.IOException;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.jmatrix.db.common.ConnectionInfo;
import net.jmatrix.db.common.SQLUtil;
import net.jmatrix.db.jsql.formatters.AbstractFormatter;

public class SQLFormatter
extends AbstractFormatter {
    DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    DateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss");
    DateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    DateFormat DATETIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public SQLFormatter(ConnectionInfo ci) {
        super(ci);
    }

    public SQLFormatter() {
    }

    @Override
    public int format(ResultSet rs, Writer writer, int rows, String sql, String table, String[] columnns) throws SQLException, IOException {
        writer.write(this.header(sql, rs) + "\n");
        ResultSetMetaData rsmd = rs.getMetaData();
        int rowcount = 0;
        while (rs.next()) {
            ++rowcount;
            writer.write(this.insertSQL(table, rs, rsmd) + "\n");
        }
        writer.flush();
        return rowcount;
    }

    private final String insertSQL(String table, ResultSet rs, ResultSetMetaData rsmd) throws SQLException {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO " + table + " (");
        int cols = rsmd.getColumnCount();
        for (i = 1; i <= cols; ++i) {
            sb.append(rsmd.getColumnName(i));
            if (i >= cols) continue;
            sb.append(",");
        }
        sb.append(")\n  VALUES(");
        for (i = 1; i <= cols; ++i) {
            sb.append(this.asSQL(rs.getObject(i), rsmd.getColumnType(i)));
            if (i >= cols) continue;
            sb.append(",");
        }
        sb.append(");");
        return sb.toString();
    }

    private final String asSQL(Object o, int colType) {
        if (o == null) {
            return "NULL";
        }
        if (o instanceof Number) {
            return ((Number)o).toString();
        }
        if (o instanceof String) {
            String value = SQLUtil.escape(o.toString());
            return "'" + value + "'";
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? "1" : "0";
        }
        if (o instanceof Date) {
            if (colType == 91) {
                return "DATE '" + this.DATE_FORMAT.format((Date)o) + "'";
            }
            if (colType == 93) {
                return "TIMESTAMP '" + this.TIMESTAMP_FORMAT.format((Date)o) + "'";
            }
            if (colType == 92) {
                return "TIME '" + this.TIME_FORMAT.format((Date)o) + "'";
            }
            System.out.println("Unknown date type " + colType + ": " + SQLUtil.jdbcTypeString(colType));
            return "'" + this.DATETIME_FORMAT.format((Date)o) + "'";
        }
        System.out.println("Unknown type " + o.getClass().getName() + ", jdbc type " + colType + ": " + SQLUtil.jdbcTypeString(colType));
        return "'" + o.toString() + "'";
    }

    @Override
    public String header(String sql, ResultSet rs, String[] columns) throws SQLException {
        StringBuilder sb = new StringBuilder();
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss ZZZZ");
        sb.append("/*\n");
        sb.append(" * Export from " + this.conInfo.getUsername() + " on " + this.conInfo.getUrl() + "\n");
        sb.append(" * SQL: " + sql + "\n");
        sb.append(" * Export on " + df.format(new Date()) + "\n");
        sb.append(" */\n\n");
        return sb.toString();
    }
}

