/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.db.jsql.formatters;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.jmatrix.db.common.ClassLogFactory;
import net.jmatrix.db.common.ConnectionInfo;
import net.jmatrix.db.common.StringUtils;
import net.jmatrix.db.common.console.TextConsole;
import net.jmatrix.db.jsql.formatters.AbstractFormatter;
import org.slf4j.Logger;

public class PrettyFormatter
extends AbstractFormatter {
    private static Logger log = ClassLogFactory.getLog();
    static final boolean debug = false;
    TextConsole console = null;
    int consoleWidth = 80;

    public PrettyFormatter() {
    }

    public PrettyFormatter(TextConsole c) {
        this.console = c;
    }

    public PrettyFormatter(ConnectionInfo ci, TextConsole c) {
        super(ci);
        this.console = c;
    }

    @Override
    public int format(ResultSet rs, Writer writer, int maxrows, String sql, String tablename, String[] columns) throws SQLException, IOException {
        if (this.console != null) {
            this.consoleWidth = this.console.getColumns();
        } else {
            Integer cw = (Integer)this.parameters.get("width");
            if (cw != null) {
                this.consoleWidth = cw;
            } else {
                log.warn("ConsoleWidth parameter is null.");
            }
            if (this.consoleWidth == -1) {
                this.consoleWidth = 80;
            }
        }
        Data data = this.getData(rs, columns, maxrows, this.consoleWidth);
        return this.format(data, writer, this.consoleWidth);
    }

    @Override
    public String header(String sql, ResultSet rs, String[] columns) throws SQLException {
        return null;
    }

    private int format(Data data, Writer writer, int width) throws IOException {
        log.trace("Formatting " + data.rowcount() + " x " + data.cols + ", width=" + width);
        int[] w = new int[data.cols];
        int rowwidth = 0;
        int availableWidth = width - data.cols - 1;
        for (int i = 0; i < data.cols; ++i) {
            Column c = data.columns.get(i);
            if (c != null) {
                log.trace(c.toString());
            }
            w[i] = (int)((double)availableWidth * (c.avewidth / data.avgTotal));
            if (w[i] > c.maxwidth) {
                w[i] = c.maxwidth;
            }
            if (w[i] < 2) {
                w[i] = 2;
            }
            rowwidth = rowwidth + w[i] + 1;
        }
        writer.append(StringUtils.pad(++rowwidth, '-') + "\n");
        StringBuilder line = new StringBuilder();
        line.append("|");
        for (int i = 0; i < data.cols; ++i) {
            Column c = data.columns.get(i);
            line.append(PrettyFormatter.exact(c.name, w[i]) + "|");
        }
        writer.append(line + "\n");
        writer.append(StringUtils.pad(rowwidth, '-') + "\n");
        int rows = data.rowcount();
        for (int i = 0; i < rows; ++i) {
            line = new StringBuilder();
            line.append("|");
            List<String> row = data.rows.get(i);
            for (int j = 0; j < data.cols; ++j) {
                line.append(PrettyFormatter.exact(row.get(j), w[j]) + "|");
            }
            writer.append(line.toString() + "\n");
        }
        writer.append(StringUtils.pad(rowwidth, '-') + "\n");
        return data.rowcount();
    }

    public String format(List items, String[] fields, int width) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, IOException {
        StringWriter sw = new StringWriter();
        Data data = this.getData(items, fields);
        this.format(data, sw, width);
        return sw.toString();
    }

    Data getData(List items, String[] fields) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method[] method = new Method[fields.length];
        Class<?> type = items.get(0).getClass();
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            String getterName = "get" + field.substring(0, 1).toUpperCase() + field.substring(1);
            method[i] = type.getMethod(getterName, new Class[0]);
        }
        Data data = new Data(fields);
        for (Object item : items) {
            ArrayList<String> row = new ArrayList<String>();
            for (int i = 0; i < fields.length; ++i) {
                Object value = method[i].invoke(item, new Object[0]);
                String svalue = null;
                svalue = value == null ? "null" : value.toString();
                row.add(svalue);
            }
            data.add(row);
        }
        return data;
    }

    Data getData(ResultSet rs, String[] columns, int maxrows, int maxstring) throws SQLException {
        Data data = new Data(rs, columns);
        for (int count = 0; rs.next() && count < maxrows; ++count) {
            ArrayList<String> row = new ArrayList<String>();
            List<Column> dc = data.columns;
            for (int i = 1; i <= data.cols; ++i) {
                String s = null;
                s = dc.get((int)(i - 1)).name != null && !dc.get((int)(i - 1)).name.equals("") ? rs.getString(dc.get((int)(i - 1)).name) : rs.getString(i);
                if (s == null) {
                    s = "NULL";
                }
                s = s.replaceAll("\n", "\\n");
                if ((s = s.replaceAll("\t", "\\t")).length() > maxstring) {
                    s = s.substring(0, maxstring);
                }
                row.add(s);
            }
            data.add(row);
        }
        data.finish();
        return data;
    }

    private static final String exact(String s, int w) {
        if (s.length() == w) {
            return s;
        }
        if (s.length() < w) {
            return s + StringUtils.pad(w - s.length(), ' ');
        }
        return s.substring(0, w - 1) + ">";
    }

    class Data {
        int cols = 0;
        List<Column> columns = new ArrayList<Column>();
        List<List<String>> rows = new ArrayList<List<String>>();
        double avgTotal = 0.0;

        public Data(ResultSet rs, String[] columns) throws SQLException {
            ResultSetMetaData rsmd = rs.getMetaData();
            if (columns != null) {
                this.cols = columns.length;
                for (String column : columns) {
                    this.addColumn(column);
                }
            } else {
                this.cols = rsmd.getColumnCount();
                for (int i = 1; i <= this.cols; ++i) {
                    this.addColumn(rsmd.getColumnName(i));
                }
                log.debug("Columns: " + this.columns);
            }
        }

        public Data(String[] fields) {
            this.cols = fields.length;
            for (int i = 0; i < fields.length; ++i) {
                this.addColumn(fields[i]);
            }
        }

        void addColumn(String name) {
            Column c = new Column();
            c.name = name;
            this.columns.add(c);
            c.add(c.name.length());
        }

        void add(List<String> row) {
            for (int i = 0; i < this.cols; ++i) {
                Column c = this.columns.get(i);
                c.add(row.get(i).length());
            }
            this.rows.add(row);
        }

        int rowcount() {
            return this.rows.size();
        }

        void finish() {
            for (int i = 0; i < this.cols; ++i) {
                this.avgTotal += this.columns.get((int)i).avewidth;
            }
        }
    }

    class Column {
        String name = null;
        int maxwidth = 0;
        double avewidth = 0.0;
        int count = 0;

        Column() {
        }

        public String toString() {
            return "Col('" + this.name + "', max=" + this.maxwidth + ", avg=" + this.avewidth + ", rowcount=" + this.count + ")";
        }

        void add(int x) {
            if (x > this.maxwidth) {
                this.maxwidth = x;
            }
            this.avewidth = (this.avewidth * (double)this.count + (double)x) / (double)(this.count + 1);
            ++this.count;
        }
    }
}

