/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.db.jsql.cli.jline.completer;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jline.console.completer.Completer;
import jline.console.completer.StringsCompleter;
import jline.internal.Log;
import net.jmatrix.db.common.ConnectionInfo;
import net.jmatrix.db.common.DBUtils;
import net.jmatrix.db.common.console.SysConsole;
import net.jmatrix.db.common.console.TextConsole;

public class TableNameCompleter
implements Completer {
    static final TextConsole console = SysConsole.getConsole();
    StringsCompleter sc = null;
    static List<String> tableCompletionTriggers = Arrays.asList("from", "describe");

    public int complete(String buffer, int pos, List<CharSequence> candidates) {
        if (this.sc == null) {
            return -1;
        }
        if (buffer == null) {
            return -1;
        }
        String lc = buffer.toLowerCase();
        String[] split = lc.split(" ");
        if (!tableCompletionTriggers.contains(split[split.length - 1]) || lc.endsWith(" ")) {
            // empty if block
        }
        return 0;
    }

    public void connect(ConnectionInfo conInfo) {
        new TableNameThread(conInfo).start();
    }

    public void disconnect() {
        this.sc = null;
    }

    private class TableNameThread
    extends Thread {
        ConnectionInfo conInfo = null;

        public TableNameThread(ConnectionInfo ci) {
            this.conInfo = ci;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            console.debug("Getting table names for completion.");
            ResultSet rs = null;
            Connection con = null;
            try {
                con = this.conInfo.connect();
                console.debug("Got new connection");
                DatabaseMetaData dbmd = con.getMetaData();
                String schema = null;
                try {
                    schema = this.conInfo.getSchema();
                }
                catch (Error er) {
                    // empty catch block
                }
                rs = dbmd.getTables(null, schema, null, null);
                ArrayList<String> tnames = new ArrayList<String>();
                while (rs.next()) {
                    tnames.add(rs.getString("TABLE_NAME"));
                }
                console.debug("Adding " + tnames.size() + " table names to completer.");
                TableNameCompleter.this.sc = new StringsCompleter(tnames);
            }
            catch (Throwable ex) {
                try {
                    Log.debug((Object[])new Object[]{"", ex});
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    DBUtils.close(con, null, rs);
                }
            }
            DBUtils.close(con, null, rs);
        }
    }
}

