/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.db.jsql.cli.commands;

import java.sql.SQLException;
import net.jmatrix.db.common.ConnectionInfo;
import net.jmatrix.db.common.console.SysConsole;
import net.jmatrix.db.common.console.TextConsole;
import net.jmatrix.db.jsql.JSQL;
import net.jmatrix.db.jsql.cli.commands.AbstractCommand;
import net.jmatrix.db.jsql.formatters.PlainFormatter;
import net.jmatrix.db.jsql.formatters.PrettyFormatter;
import net.jmatrix.db.jsql.formatters.SQLFormatter;

public class SetCommand
extends AbstractCommand {
    static final TextConsole console = SysConsole.getConsole();

    public SetCommand(JSQL j) {
        super(j);
    }

    @Override
    public boolean accepts(String command) {
        return command.equalsIgnoreCase("set");
    }

    @Override
    public void process(String line) throws Exception {
        String[] split = line.split("\\ ");
        if (split.length == 1) {
            this.display();
        } else if (split.length == 3) {
            this.set(split[1], split[2], null);
        } else if (split.length == 4) {
            this.set(split[1], split[2], split[3]);
        } else {
            console.warn("Malformed set command.");
            return;
        }
    }

    void display() throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append("connection\n");
        if (this.jsql.isConnected()) {
            ConnectionInfo ci = this.jsql.getConnectionInfo();
            sb.append("  readonly " + ci.getDefaultConnection().isReadOnly() + "\n");
            sb.append("  autocommit " + ci.getDefaultConnection().getAutoCommit() + "\n");
            sb.append("  schema " + ci.getSchema() + "\n");
            sb.append("  catalog " + ci.getCatalog() + "\n");
        } else {
            sb.append("   not connected\n");
        }
        sb.append("\n");
        sb.append("log\n");
        sb.append("  level " + console.getLevel().toString() + "\n");
        console.info(sb.toString());
    }

    void set(String subsystem, String key, String value) throws Exception {
        block7 : switch (subsystem) {
            case "connection": 
            case "con": {
                if (!this.jsql.isConnected()) {
                    console.warn("not connected.");
                    return;
                }
                switch (key) {
                    case "catalog": {
                        this.jsql.getConnectionInfo().setCatalog(value);
                        break block7;
                    }
                    case "schema": {
                        this.jsql.getConnectionInfo().setSchema(value);
                        break block7;
                    }
                }
                console.warn("Don't know how to set '" + key + "' on connection.");
                break;
            }
            case "jsql": {
                switch ("formatter") {
                    case "pretty": {
                        PrettyFormatter f = new PrettyFormatter(this.jsql.getConnectionInfo(), this.jsql.getConsole());
                        this.jsql.setFormatter(f);
                        break block7;
                    }
                }
                console.warn("Don't understand formatter value " + value);
                break;
            }
            case "log": {
                if (key.equals("level") || value != null) {
                    console.setLevel(TextConsole.Level.valueOf(value.toUpperCase()));
                    break;
                }
                console.warn("Malformed set command.");
                break;
            }
            case "formatter": {
                if (key.equals("plain")) {
                    this.jsql.setFormatter(new PlainFormatter());
                } else if (key.equals("pretty")) {
                    this.jsql.setFormatter(new PrettyFormatter(this.jsql.getConsole()));
                } else if (key.equals("sql")) {
                    this.jsql.setFormatter(new SQLFormatter());
                } else {
                    console.warn("Don't know formatter '" + key + "' - known values: [plain, pretty, sql]");
                }
                console.info("Current Formatter: " + this.jsql.getFormatter());
                break;
            }
            default: {
                console.warn("Don't understand set subsystem '" + subsystem + "'");
            }
        }
    }
}

