/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.db.jsql.cli;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import jline.console.completer.Completer;
import net.jmatrix.db.common.console.SysConsole;
import net.jmatrix.db.common.console.TextConsole;
import net.jmatrix.db.jsql.ExportSQL;
import net.jmatrix.db.jsql.JSQL;
import net.jmatrix.db.jsql.cli.LineModeProcessor;

public class ExportProcessor
implements LineModeProcessor {
    static final TextConsole console = SysConsole.getConsole();
    static final String TABLE = "table";
    static final String FILE = "file";
    static final String WHERE = "where";
    JSQL jsql = null;
    static String[] prompts = new String[]{"file", "table", "where"};
    String[] defaults = new String[]{"", "", ""};
    int pointer = 0;
    String prompt = null;
    String def = null;
    Map<String, String> values = new HashMap<String, String>();

    public ExportProcessor(JSQL j, String line) {
        this.jsql = j;
        String[] split = line.split("\\ ");
        if (split.length > 1) {
            this.defaults[1] = split[1];
            this.defaults[0] = split[1] + ".sql";
        }
    }

    @Override
    public String prompt() {
        this.prompt = prompts[this.pointer];
        this.def = this.defaults[this.pointer];
        ++this.pointer;
        return "Export-" + this.prompt + " [" + this.def + "]>";
    }

    @Override
    public LineModeProcessor processLine(String line) {
        if ((line = line.trim()).length() == 0) {
            this.values.put(this.prompt, this.def);
        } else {
            this.values.put(this.prompt, line);
            this.defaults[this.pointer - 1] = line;
        }
        if (this.pointer == prompts.length) {
            this.export();
            return null;
        }
        return this;
    }

    void export() {
        String filename = this.values.get(FILE);
        String table = this.values.get(TABLE);
        String where = this.values.get(WHERE);
        try {
            ExportSQL export = new ExportSQL(this.jsql.getConnectionInfo());
            File file = new File(filename);
            export.export(file, table, where);
        }
        catch (Exception ex) {
            console.error("Error exporting from " + table + " where " + where + " to " + filename, ex);
        }
    }

    @Override
    public Collection<Completer> getCompleters() {
        return null;
    }
}

