/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.db.jsql;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;
import jline.console.ConsoleReader;
import jline.console.completer.Completer;
import jline.console.completer.FileNameCompleter;
import jline.console.completer.StringsCompleter;

public class JLineEx {
    public static void usage() {
        System.out.println("Usage: java " + JLineEx.class.getName() + " [none/simple/files/dictionary [trigger mask]]");
        System.out.println("  none - no completors");
        System.out.println("  simple - a simple completor that comples \"foo\", \"bar\", and \"baz\"");
        System.out.println("  files - a completor that comples file names");
        System.out.println("  classes - a completor that comples java class names");
        System.out.println("  trigger - a special word which causes it to assume the next line is a password");
        System.out.println("  mask - is the character to print in place of the actual password character");
        System.out.println("  color - colored prompt and feedback");
        System.out.println("\n  E.g - java Example simple su '*'\nwill use the simple compleator with 'su' triggering\nthe use of '*' as a password mask.");
    }

    public static void main(String[] args) throws IOException {
        try {
            String line;
            Character mask = null;
            String trigger = null;
            boolean color = false;
            ConsoleReader reader = new ConsoleReader();
            reader.setPrompt("prompt> ");
            if (args == null || args.length == 0) {
                JLineEx.usage();
                return;
            }
            LinkedList<Object> completors = new LinkedList<Object>();
            if (args.length > 0 && !args[0].equals("none")) {
                if (args[0].equals("files")) {
                    completors.add(new FileNameCompleter());
                } else if (args[0].equals("simple")) {
                    completors.add(new StringsCompleter(new String[]{"foo", "bar", "baz"}));
                } else if (args[0].equals("color")) {
                    color = true;
                    reader.setPrompt("\u001b[1mfoo\u001b[0m@bar\u001b[32m@baz\u001b[0m> ");
                } else {
                    JLineEx.usage();
                    return;
                }
            }
            if (args.length == 3) {
                mask = Character.valueOf(args[2].charAt(0));
                trigger = args[1];
            }
            for (Completer completer : completors) {
                reader.addCompleter(completer);
            }
            PrintWriter printWriter = new PrintWriter(reader.getOutput());
            while ((line = reader.readLine()) != null) {
                if (color) {
                    printWriter.println("\u001b[33m======>\u001b[0m\"" + line + "\"");
                } else {
                    printWriter.println("======>\"" + line + "\"");
                }
                printWriter.flush();
                if (trigger != null && line.compareTo(trigger) == 0) {
                    line = reader.readLine("password> ", mask);
                }
                if (!line.equalsIgnoreCase("quit") && !line.equalsIgnoreCase("exit")) {
                    if (!line.equalsIgnoreCase("cls")) continue;
                    reader.clearScreen();
                    continue;
                }
                break;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

