/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.db.common;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import net.jmatrix.db.common.PerfTrack;

public final class StreamUtil {
    static final int EOS = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int pump(InputStream is, OutputStream os) throws IOException {
        String perf = "pump(" + is + " -> " + os + ")";
        try {
            PerfTrack.start(perf);
            byte[] buffer = new byte[8192];
            int bytes = is.read(buffer);
            int totalBytes = 0;
            while (bytes > 0) {
                totalBytes += bytes;
                os.write(buffer, 0, bytes);
                bytes = is.read(buffer);
            }
            os.flush();
            os.close();
            is.close();
            int n = totalBytes;
            return n;
        }
        finally {
            PerfTrack.stop(perf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int pump(Reader is, Writer os) throws IOException {
        String perf = "pump(" + is + " -> " + os + ")";
        try {
            PerfTrack.start(perf);
            char[] buffer = new char[8192];
            int bytes = is.read(buffer);
            int totalBytes = 0;
            while (bytes > 0) {
                totalBytes += bytes;
                os.write(buffer, 0, bytes);
                bytes = is.read(buffer);
            }
            os.flush();
            os.close();
            is.close();
            int n = totalBytes;
            return n;
        }
        finally {
            PerfTrack.stop(perf);
        }
    }

    public static final void unbufferedPump(InputStream is, OutputStream os) throws IOException {
        int b = is.read();
        while (b != -1) {
            os.write(b);
            b = is.read();
        }
        os.flush();
        os.close();
        is.close();
    }

    public static final void pumpExactly(InputStream is, OutputStream os, int bytes) throws IOException {
        for (int i = 0; i < bytes; ++i) {
            os.write(is.read());
        }
        os.flush();
        os.close();
        is.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readToString(InputStream is) throws IOException {
        String perf = "readToString()";
        try {
            PerfTrack.start(perf);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            StreamUtil.pump(is, baos);
            String string = baos.toString();
            return string;
        }
        finally {
            PerfTrack.stop(perf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readToString(InputStream is, String encoding) throws IOException {
        String perf = "readToString()";
        try {
            PerfTrack.start(perf);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            StreamUtil.pump(is, baos);
            String string = baos.toString(encoding);
            return string;
        }
        finally {
            PerfTrack.stop(perf);
        }
    }

    public static String readToString(File f) throws IOException {
        return new String(StreamUtil.readFully(new FileInputStream(f)));
    }

    public static byte[] readFully(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int b = is.read();
        while (b != -1) {
            baos.write(b);
            b = is.read();
        }
        is.close();
        return baos.toByteArray();
    }

    public static byte[] readFully(File f) throws IOException {
        return StreamUtil.readFully(new FileInputStream(f));
    }

    public static final void write(String s, Writer w) throws IOException {
        w.write(s);
        w.flush();
    }

    public static final void write(String s, File f) throws IOException {
        FileWriter fw = new FileWriter(f);
        StreamUtil.write(s, fw);
        fw.close();
    }

    public static final void write(byte[] b, File f) throws IOException {
        FileOutputStream fos = new FileOutputStream(f);
        fos.write(b);
        fos.flush();
        fos.close();
    }

    public static final void write(InputStream is, File f) throws IOException {
        StreamUtil.pump(is, new FileOutputStream(f));
    }

    public static final void close(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static final void close(Reader is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static final void close(Writer w) {
        if (w != null) {
            try {
                w.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

