/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.db.jsql.formatters;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import net.jmatrix.db.common.ConnectionInfo;
import net.jmatrix.db.common.DebugUtils;
import net.jmatrix.db.jsql.formatters.RSFormatter;

public abstract class AbstractFormatter
implements RSFormatter {
    protected ConnectionInfo conInfo = null;
    protected int maxrows = Integer.MAX_VALUE;
    Map<String, Object> parameters = new HashMap<String, Object>();

    protected AbstractFormatter(ConnectionInfo ci) {
        this.conInfo = ci;
    }

    protected AbstractFormatter() {
    }

    public String toString() {
        return DebugUtils.shortClassname(this) + ": " + this.parameters;
    }

    @Override
    public String format(ResultSet rs) throws SQLException, IOException {
        return this.format(rs, this.maxrows);
    }

    @Override
    public String format(ResultSet rs, int rows) throws SQLException, IOException {
        StringWriter sw = new StringWriter();
        this.format(rs, sw, rows, null, null);
        return sw.toString();
    }

    @Override
    public int format(ResultSet rs, Writer writer, int rows, String sql, String tablename) throws SQLException, IOException {
        return this.format(rs, writer, rows, sql, tablename, null);
    }

    @Override
    public String header(String sql, ResultSet rs) throws SQLException {
        return this.header(sql, rs, null);
    }

    @Override
    public int format(ResultSet rs, Writer writer) throws SQLException, IOException {
        return this.format(rs, writer, this.maxrows, null, null);
    }

    @Override
    public void setConnectionInfo(ConnectionInfo conInfo) {
        this.conInfo = conInfo;
    }

    @Override
    public void setMaxRows(int m) {
        this.maxrows = m;
    }

    @Override
    public void set(String k, Object v) {
        this.parameters.put(k, v);
    }
}

