/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.db.jsql.cli.commands;

import java.io.IOException;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import net.jmatrix.db.common.ConnectionInfo;
import net.jmatrix.db.common.DBUtils;
import net.jmatrix.db.common.console.SysConsole;
import net.jmatrix.db.common.console.TextConsole;
import net.jmatrix.db.jsql.JSQL;
import net.jmatrix.db.jsql.cli.commands.AbstractCommand;
import net.jmatrix.db.jsql.formatters.PrettyFormatter;
import net.jmatrix.db.jsql.formatters.RSFormatter;

public class ShowCommand
extends AbstractCommand {
    static final TextConsole console = SysConsole.getConsole();
    static final String usage = "Usage: show {db|tables|views|procedures|connection|driver|catalogs} [namePattern]";

    public ShowCommand(JSQL j) {
        super(j);
    }

    @Override
    public boolean accepts(String command) {
        return command != null && command.equals("show");
    }

    @Override
    public void process(String line) throws Exception {
        String[] split = line.split(" ");
        if (!this.jsql.isConnected()) {
            System.out.println("Not connected.");
            return;
        }
        Connection con = this.jsql.getConnection();
        switch (split[1]) {
            case "db": {
                this.showDB(con);
                break;
            }
            case "tables": {
                this.showTables(con, split, "TABLE");
                break;
            }
            case "views": {
                this.showTables(con, split, "VIEW");
                break;
            }
            case "connection": {
                this.showConnection(con);
                break;
            }
            case "catalogs": {
                this.showCatalogs(con);
                break;
            }
            case "driver": {
                this.showDriver();
                break;
            }
            case "procedures": {
                this.showProcedures(con, split);
                break;
            }
            default: {
                console.warn(usage);
            }
        }
    }

    private void showCatalogs(Connection con) throws Exception {
        console.info("Getting catalogs...");
        try {
            DatabaseMetaData dbmd = con.getMetaData();
            ResultSet rs = dbmd.getCatalogs();
            RSFormatter formatter = this.jsql.getFormatter();
            formatter.format(rs);
        }
        catch (Throwable t) {
            console.error("Cannot get Catalogs", t);
        }
    }

    void showDB(Connection con) throws SQLException {
        DatabaseMetaData dbmd = con.getMetaData();
        ConnectionInfo ci = this.jsql.getConnectionInfo();
        StringBuilder info = new StringBuilder();
        info.append("Connected to " + dbmd.getDatabaseProductName() + "\n");
        info.append("  url: " + ci.getUrl() + "\n");
        info.append("   as: " + ci.getUsername() + "\n");
        info.append("  Version: " + dbmd.getDatabaseProductVersion() + "\n");
        info.append("    catalog term: " + dbmd.getCatalogTerm() + "\n");
        info.append("     schema term: " + dbmd.getSchemaTerm() + "\n");
        info.append("  procedure term: " + dbmd.getProcedureTerm() + "\n");
        console.println(info.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void showTables(Connection con, String[] split, String type) throws SQLException, IOException {
        ArrayList tables;
        ResultSet rs;
        block7: {
            DatabaseMetaData dbmd = con.getMetaData();
            rs = null;
            tables = new ArrayList();
            try {
                console.debug("Getting tables");
                String schema = null;
                try {
                    schema = con.getSchema();
                }
                catch (Error er) {
                    // empty catch block
                }
                String namePattern = null;
                if (split.length == 3) {
                    namePattern = split[2];
                }
                rs = dbmd.getTables(null, schema, namePattern, new String[]{type});
                PrettyFormatter pf = new PrettyFormatter(this.jsql.getConnectionInfo(), this.jsql.getConsole());
                StringWriter sw = new StringWriter();
                int rows = pf.format(rs, sw, 500, null, null, new String[]{"TABLE_NAME", "TABLE_TYPE", "TABLE_SCHEM", "TABLE_CAT"});
                if (rows > 0) {
                    console.println(sw.toString());
                    break block7;
                }
                console.print("No tables found.");
            }
            catch (Throwable throwable) {
                DBUtils.close(rs);
                throw throwable;
            }
        }
        DBUtils.close(rs);
        Collections.sort(tables);
        StringBuilder sb = new StringBuilder();
        for (String t : tables) {
            sb.append("  " + t + "\n");
        }
        sb.append(tables.size() + " " + type + "s.");
        console.println(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void showProcedures(Connection con, String[] split) throws SQLException, IOException {
        DatabaseMetaData dbmd = con.getMetaData();
        ResultSet rs = null;
        try {
            console.debug("Getting tables");
            String schema = null;
            try {
                schema = con.getSchema();
            }
            catch (Error er) {
                // empty catch block
            }
            String namePattern = null;
            if (split.length == 3) {
                namePattern = split[2];
            }
            rs = dbmd.getProcedures(null, schema, namePattern);
            PrettyFormatter pf = new PrettyFormatter(this.jsql.getConnectionInfo(), this.jsql.getConsole());
            StringWriter sw = new StringWriter();
            pf.format(rs, sw, 500, null, null, new String[]{"PROCEDURE_NAME", "PROCEDURE_TYPE", "PROCEDURE_SCHEM", "PROCEDURE_CAT"});
            console.println(sw.toString());
        }
        catch (Throwable throwable) {
            DBUtils.close(rs);
            throw throwable;
        }
        DBUtils.close(rs);
    }

    void showConnection(Connection con) throws SQLException {
        String schema = null;
        try {
            schema = con.getSchema();
        }
        catch (Error ex) {
            schema = "not supported.";
        }
        console.info("  con.getSchmea(): " + schema);
        console.info("  con.getCatalog(): " + con.getCatalog());
        console.info("  con.getAutocommt(): " + con.getAutoCommit());
        console.info("  con.isReadOnly(): " + con.isReadOnly());
    }

    void showDriver() throws SQLException {
        if (this.jsql.getConnectionInfo() == null) {
            console.info("Not connected.");
            return;
        }
        Driver driver = this.jsql.getConnectionInfo().getDriver();
        console.info("Driver:: " + driver.getClass().getName());
        console.info("  driver.getMajorVersion(): " + driver.getMajorVersion());
        console.info("  driver.getMinorVersion(): " + driver.getMinorVersion());
    }
}

