/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.db.jsql.cli.commands;

import java.io.IOException;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.jmatrix.db.common.ConnectionInfo;
import net.jmatrix.db.common.DBUtils;
import net.jmatrix.db.common.console.SysConsole;
import net.jmatrix.db.common.console.TextConsole;
import net.jmatrix.db.jsql.JSQL;
import net.jmatrix.db.jsql.cli.commands.AbstractCommand;
import net.jmatrix.db.jsql.formatters.PrettyFormatter;

public class DescribeCommand
extends AbstractCommand {
    static final TextConsole console = SysConsole.getConsole();
    static final String TABLE = "table";
    static final String PROCEDURE = "procedure";
    static final String VIEW = "view";

    public DescribeCommand(JSQL j) {
        super(j);
    }

    @Override
    public boolean accepts(String command) {
        return command != null && (command.equals("desc") || command.equals("describe"));
    }

    @Override
    public void process(String line) throws Exception {
        String[] split = line.split(" ");
        if (!this.jsql.isConnected()) {
            console.warn("Not connected.");
            return;
        }
        String type = null;
        String object = null;
        if (split.length < 2) {
            console.warn("Malformed 'describe' command.  Describe what?");
            return;
        }
        if (split.length == 2) {
            type = TABLE;
            object = split[1];
        } else if (split.length == 3) {
            String stype = split[1].toLowerCase();
            object = split[2];
            switch (stype) {
                case "proc": 
                case "procedure": {
                    type = PROCEDURE;
                    break;
                }
                case "table": {
                    type = TABLE;
                    break;
                }
                case "view": {
                    type = VIEW;
                    break;
                }
                default: {
                    console.warn("Can't understand type '" + stype + "'");
                    return;
                }
            }
        } else {
            console.warn("Malformed 'describe' command.  Describe what?");
            return;
        }
        Connection con = this.jsql.getConnection();
        switch (type) {
            case "view": 
            case "table": {
                this.describeTable(con, object);
                if (!type.equals(TABLE)) break;
                this.describeTableIndexes(con, object);
                break;
            }
            case "procedure": {
                this.describeProc(con, object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void describeTable(Connection con, String table) throws SQLException, IOException {
        DatabaseMetaData dbmd = con.getMetaData();
        ResultSet rs = null;
        try {
            console.debug("Getting columns for " + table);
            ConnectionInfo ci = this.jsql.getConnectionInfo();
            rs = dbmd.getColumns(ci.getCatalog(), ci.getSchema(), table.toUpperCase(), null);
            PrettyFormatter pf = new PrettyFormatter(this.jsql.getConnectionInfo(), this.jsql.getConsole());
            StringWriter sw = new StringWriter();
            pf.format(rs, sw, 500, null, null, new String[]{"COLUMN_NAME", "TYPE_NAME", "COLUMN_SIZE", "TABLE_SCHEM", "TABLE_CAT", "IS_NULLABLE"});
            console.println(sw.toString());
        }
        catch (Throwable throwable) {
            DBUtils.close(rs);
            throw throwable;
        }
        DBUtils.close(rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void describeTableIndexes(Connection con, String tablename) throws SQLException, IOException {
        ResultSet rs;
        block3: {
            DatabaseMetaData dbmd = con.getMetaData();
            rs = null;
            try {
                console.debug("Getting indexes for " + tablename);
                ConnectionInfo ci = this.jsql.getConnectionInfo();
                rs = dbmd.getIndexInfo(null, null, tablename, false, false);
                PrettyFormatter pf = new PrettyFormatter(this.jsql.getConnectionInfo(), this.jsql.getConsole());
                StringWriter sw = new StringWriter();
                int rows = pf.format(rs, sw, 500, null, null, new String[]{"COLUMN_NAME", "INDEX_NAME", "CARDINALITY", "NON_UNIQUE"});
                if (rows > 0) {
                    console.println("indexes:");
                    console.println(sw.toString());
                    break block3;
                }
                console.println("No indexes found on " + tablename);
            }
            catch (Throwable throwable) {
                DBUtils.close(rs);
                throw throwable;
            }
        }
        DBUtils.close(rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void describeProc(Connection con, String proc) throws SQLException, IOException {
        DatabaseMetaData dbmd = con.getMetaData();
        ResultSet rs = null;
        try {
            console.debug("Getting columns for " + proc);
            ConnectionInfo ci = this.jsql.getConnectionInfo();
            rs = dbmd.getProcedureColumns(ci.getCatalog(), ci.getSchema(), proc.toUpperCase(), null);
            PrettyFormatter pf = new PrettyFormatter(this.jsql.getConnectionInfo(), this.jsql.getConsole());
            StringWriter sw = new StringWriter();
            pf.format(rs, sw, 500, null, null, new String[]{"COLUMN_NAME", "COLUMN_TYPE", "TYPE_NAME", "PROCEDURE_SCHEM", "PROCEDURE_CAT", "IS_NULLABLE"});
            console.println(sw.toString());
        }
        catch (Throwable throwable) {
            DBUtils.close(rs);
            throw throwable;
        }
        DBUtils.close(rs);
    }
}

