/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.db.schema.action;

import java.io.File;
import java.util.List;
import net.jmatrix.db.common.ClassLogFactory;
import net.jmatrix.db.schema.DBM;
import net.jmatrix.db.schema.DBMException;
import net.jmatrix.db.schema.DBVersion;
import net.jmatrix.db.schema.DiskVersion;
import net.jmatrix.db.schema.SQLStatement;
import net.jmatrix.db.schema.action.AbstractAction;
import org.slf4j.Logger;

public class RollbackDiskAction
extends AbstractAction {
    private static Logger log = ClassLogFactory.getLog();
    DiskVersion diskVer = null;

    public RollbackDiskAction(DBM d, DiskVersion dv) {
        super(d);
        this.diskVer = dv;
    }

    public String toString() {
        return "RollbackDisk(" + this.diskVer.getVersion() + ")";
    }

    @Override
    public String summary() {
        StringBuilder sb = new StringBuilder();
        sb.append("Rollback: DiskVersion " + this.diskVer.getVersion() + " at " + this.diskVer.getPath() + "\n");
        List<File> files = this.diskVer.getRollbackFiles();
        for (File f : files) {
            sb.append("          File: " + f.getName() + "\n");
        }
        return sb.toString();
    }

    @Override
    public boolean execute() throws DBMException {
        try {
            log.info(">>>>>>>>>>>>> Disk Rollback " + this.diskVer);
            DBVersion currentVersion = this.dbm.getDBMData().getCurrentVersion();
            if (this.diskVer.getRollbackStatements() == null) {
                log.info("Version " + this.diskVer.getVersion() + " has no rollback statements.");
                return false;
            }
            int count = 0;
            boolean versionSuccess = true;
            for (SQLStatement statement : this.diskVer.getRollbackStatements()) {
                ++count;
                boolean success = this.dbm.executeStatement(statement);
                if (success) continue;
                log.warn("Failed to execute rollback statement " + count + " from Version " + this.diskVer.getVersion());
                log.warn("   Path: " + statement.getFile());
                versionSuccess = false;
            }
            String previousVersion = this.dbm.getDBMData().getPreviousVersion();
            log.info("DBM Reports previous version as " + previousVersion);
            log.info("Current Version: " + currentVersion + ", rollback requested " + this.diskVer.getApplyCount());
            if (versionSuccess) {
                if (currentVersion != null && currentVersion.getVersion().equals(this.diskVer.getVersion())) {
                    if (previousVersion != null) {
                        log.info("Setting DBM Version to " + previousVersion);
                        this.dbm.getDBMData().setVersion(previousVersion, "ROLLBACK", this.diskVer.getPath().getAbsolutePath(), false, null, "rollback " + this.diskVer, null);
                    } else {
                        log.warn("Previous schema version is NULL.  Set version manually if appropriate.");
                    }
                } else {
                    log.warn("Rolling back something other than most recent version.");
                    log.warn("Not updating DBM_VERSION. Set manually if appropriate.");
                }
            } else {
                log.error("Some errors in rollback. FIX MANUALLY. Not updating DBM_VERSION");
            }
            return versionSuccess;
        }
        catch (Exception ex) {
            throw new DBMException("Error Rolling back " + this.diskVer.getVersion() + ".", ex);
        }
    }
}

