/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.db.schema.action;

import net.jmatrix.db.common.ClassLogFactory;
import net.jmatrix.db.common.DebugUtils;
import net.jmatrix.db.schema.DBM;
import net.jmatrix.db.schema.DBMException;
import net.jmatrix.db.schema.DBVersion;
import net.jmatrix.db.schema.SQLStatement;
import net.jmatrix.db.schema.action.AbstractAction;
import org.slf4j.Logger;

public class RollbackDBAction
extends AbstractAction {
    private static Logger log = ClassLogFactory.getLog();
    DBVersion dbVer = null;

    public RollbackDBAction(DBM d, DBVersion dv) {
        super(d);
        this.dbVer = dv;
    }

    public String toString() {
        return "RollbackDB(" + this.dbVer.getVersion() + "/" + this.dbVer.getId() + ")";
    }

    @Override
    public String summary() {
        StringBuilder sb = new StringBuilder();
        sb.append("Rollback: DBVersion " + this.dbVer.getVersion() + " at " + this.dbVer.getId() + "\n");
        for (String sql : this.dbVer.getRollbackSql()) {
            sb.append(DebugUtils.indent(sql, 3) + ";\n");
        }
        return sb.toString();
    }

    @Override
    public boolean execute() throws DBMException {
        try {
            log.info(">>>>>>>>>>>>> DB Rollback " + this.dbVer);
            DBVersion currentVersion = this.dbm.getDBMData().getCurrentVersion();
            if (this.dbVer.getRollbackSql() == null) {
                log.info("Version " + this.dbVer.getVersion() + " has no rollback statements.");
                return false;
            }
            int count = 0;
            boolean versionSuccess = true;
            for (SQLStatement statement : this.dbVer.getRollbackStatements()) {
                ++count;
                boolean success = this.dbm.executeStatement(statement);
                if (success) continue;
                log.warn("Failed to execute rollback statement " + count + " from Version " + this.dbVer.getRollbackPath());
                log.warn("   Path: " + statement.getFile());
                versionSuccess = false;
            }
            DBVersion previousVersion = this.dbm.findPreviousDBApply(currentVersion.getVersion());
            log.info("DBM Reports previous version as " + previousVersion);
            log.info("Current Version: " + currentVersion + ", rollback requested " + this.dbVer.getVersion());
            if (versionSuccess) {
                if (currentVersion != null && currentVersion.getVersion().equals(this.dbVer.getVersion())) {
                    if (previousVersion != null) {
                        log.info("Setting DBM Version to " + previousVersion);
                        this.dbm.getDBMData().setVersion(previousVersion.getVersion().toString(), "ROLLBACK", this.dbVer.getRollbackPath(), false, null, "rollback " + this.dbVer, null);
                    } else {
                        log.warn("Previous schema version is NULL.  Set version manually if appropriate.");
                    }
                } else {
                    log.warn("Rolling back something other than most recent version.");
                    log.warn("Not updating DBM_VERSION. Set manually if appropriate.");
                }
            } else {
                log.error("Some errors in rollback. FIX MANUALLY. Not updating DBM_VERSION");
            }
            return versionSuccess;
        }
        catch (Exception ex) {
            throw new DBMException("Error Rolling back " + this.dbVer.getVersion() + ".", ex);
        }
    }
}

