/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.db.schema;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import net.jmatrix.db.common.Version;
import net.jmatrix.db.schema.DBVersion;
import net.jmatrix.db.schema.DiskVersion;

public class VersionDisplay {
    Version version = null;
    DiskVersion diskVersion;
    DBVersion dbVersion = null;
    DateFormat df = new SimpleDateFormat("ddMMMyyyy HH:mm");

    public VersionDisplay() {
    }

    public VersionDisplay(Version v, DiskVersion dv, DBVersion dbv) {
        this.version = v;
        this.diskVersion = dv;
        this.dbVersion = dbv;
    }

    public Version getVersion() {
        return this.version;
    }

    public DiskVersion getDiskVersion() {
        return this.diskVersion;
    }

    public DBVersion getDbVersion() {
        return this.dbVersion;
    }

    public String getApplyCount() {
        if (this.diskVersion != null) {
            return "" + this.diskVersion.getApplyCount();
        }
        return "";
    }

    public String getRollbackCount() {
        if (this.diskVersion != null) {
            return "" + this.diskVersion.getRollbackCount();
        }
        return "";
    }

    public String getDiskDate() {
        if (this.diskVersion != null) {
            return this.df.format(this.diskVersion.getDate());
        }
        return "";
    }

    public String getDbDate() {
        if (this.dbVersion != null) {
            return this.df.format(this.dbVersion.getApplyDate());
        }
        return "";
    }

    public String getAction() {
        if (this.dbVersion != null) {
            return this.dbVersion.getAction();
        }
        return "";
    }
}

