/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.db.schema;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import net.jmatrix.db.common.ClassLogFactory;
import net.jmatrix.db.common.ConnectionInfo;
import net.jmatrix.db.common.DBUtils;
import net.jmatrix.db.common.DebugUtils;
import net.jmatrix.db.common.Version;
import net.jmatrix.db.common.console.SysConsole;
import net.jmatrix.db.common.console.TextConsole;
import net.jmatrix.db.jsql.formatters.PrettyFormatter;
import net.jmatrix.db.schema.DBVersion;
import net.jmatrix.db.schema.DiskVersion;
import net.jmatrix.db.schema.SQLStatement;
import net.jmatrix.db.schema.VersionDisplay;
import net.jmatrix.db.schema.action.AbstractAction;
import net.jmatrix.db.schema.action.Action;
import net.jmatrix.db.schema.action.ApplyAction;
import net.jmatrix.db.schema.action.InitAction;
import net.jmatrix.db.schema.action.ManualAction;
import net.jmatrix.db.schema.action.ReapplyAction;
import net.jmatrix.db.schema.action.RollbackDBAction;
import net.jmatrix.db.schema.action.RollbackDiskAction;
import net.jmatrix.db.schema.data.v2.DBMData;
import net.jmatrix.db.schema.data.v2.DBMLock;
import org.slf4j.Logger;

public class DBM {
    static TextConsole console = SysConsole.getConsole();
    private static Logger log = ClassLogFactory.getLog();
    public static final String DBM = "DBM";
    public static final String APPLY = "APPLY";
    public static final String ROLLBACK = "ROLLBACK";
    public static final String MANUAL = "MANUAL";
    File path = null;
    DBMData dbmdata = null;
    ConnectionInfo conInfo = null;
    List<DiskVersion> diskVersions = null;
    List<DBVersion> dbVersions = null;
    int LOCK_TIMEOUT = 60000;

    public DBM(String driver, String url, String user, String pass, File p) throws SQLException {
        this(new ConnectionInfo(driver, url, user, pass), p);
    }

    public DBM(ConnectionInfo ci, File p) throws SQLException {
        this.path = p;
        this.conInfo = ci;
        this.dbmdata = new DBMData(this.conInfo);
    }

    public DBMData getDBMData() {
        return this.dbmdata;
    }

    public void init() throws IOException, SQLException {
        log.debug("DBM.init()");
        this.conInfo.initDefaultConnection();
        this.reloadDiskVersions();
        if (!this.conInfo.isConnected()) {
            this.conInfo.connect();
        }
        this.reloadDBVersions();
    }

    public void destroy() {
        log.debug("DBM.destroy()");
        if (this.conInfo != null) {
            this.conInfo.close();
        }
    }

    public void initDB() throws SQLException, IOException {
        this.dbmdata.init();
    }

    public void showDBHistory() throws Exception {
        List<DBVersion> dbversions = this.dbmdata.getDBVersions();
        PrettyFormatter pf = new PrettyFormatter();
        String[] fields = new String[]{"version", "action", "hostname", "hostuser", "dbuser", "rollback", "dbChecksum", "fileChecksum", "id"};
        String s = pf.format(dbversions, fields, console.getColumns());
        log.info(s);
        log.info("");
        log.info("Current DB Version: " + this.getCurrentDBVersion());
    }

    public void showDiskVersions() throws Exception {
        if (this.diskVersions == null) {
            log.warn("No Schema Versions on Disk at " + this.path);
            return;
        }
        PrettyFormatter pf = new PrettyFormatter();
        String[] fields = new String[]{"version", "applyCount", "rollbackCount", "checksum"};
        String s = pf.format(this.diskVersions, fields, console.getColumns());
        log.info(s);
        log.info("");
        log.info("Current DB Version: " + this.getCurrentDBVersion());
    }

    public void showVersionStatus() throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, IOException, SQLException {
        this.reloadDBVersions();
        if (this.diskVersions == null) {
            log.warn("No Schema Versions on Disk at " + this.path);
            return;
        }
        if (this.dbVersions == null) {
            log.warn("no Schema Versions in DB at " + this.conInfo);
            return;
        }
        TreeSet<Version> allVersions = new TreeSet<Version>();
        for (DiskVersion diskVersion : this.diskVersions) {
            allVersions.add(diskVersion.getVersion());
        }
        for (DBVersion dBVersion : this.dbVersions) {
            allVersions.add(dBVersion.getVersion());
        }
        ArrayList<Version> avlist = new ArrayList<Version>();
        avlist.addAll(allVersions);
        Collections.sort(avlist);
        Version version = this.getCurrentDBVersion();
        ArrayList<VersionDisplay> vdlist = new ArrayList<VersionDisplay>();
        for (Version version2 : avlist) {
            String sver = version2.toString();
            DBVersion dbv = this.findLatestDBVersion(sver);
            if (dbv != null && dbv.getVersion().compareTo(version) > 0) {
                dbv = null;
            }
            DiskVersion dv = this.findDiskVersion(sver);
            VersionDisplay vd = new VersionDisplay(version2, dv, dbv);
            vdlist.add(vd);
        }
        PrettyFormatter pf = new PrettyFormatter();
        String report = pf.format(vdlist, new String[]{"version", "applyCount", "rollbackCount", "dbDate", "action"}, console.getColumns());
        log.info(report);
        log.info("");
        log.info("Current DB Version: " + this.getCurrentDBVersion());
    }

    public boolean reloadDBVersions() throws SQLException {
        log.debug("Reloading DBM DB Versions from " + this.conInfo.getUrl());
        if (this.dbmdata.isDBMSchemaCurrent()) {
            this.dbVersions = this.dbmdata.getDBVersions();
            return true;
        }
        log.warn("DBM Schema not available or out date.  Update w/ init.");
        return false;
    }

    public List<DiskVersion> reloadDiskVersions() throws IOException {
        log.debug("Reloading DBM Disk Versions from " + this.path);
        if (this.path == null) {
            return null;
        }
        File[] vdirs = this.path.listFiles(new FileFilter(){

            @Override
            public boolean accept(File path) {
                return path.isDirectory();
            }
        });
        this.diskVersions = new ArrayList<DiskVersion>();
        for (File vdir : vdirs) {
            DiskVersion dver = new DiskVersion(vdir);
            if (dver.getApplyCount() <= 0 && dver.getRollbackCount() <= 0) {
                log.warn("Disk version at path " + vdir + " does not have any SQL. ignoring.");
                continue;
            }
            this.diskVersions.add(dver);
        }
        Collections.sort(this.diskVersions);
        return this.diskVersions;
    }

    public Version getMaxDiskVersion() throws IOException {
        List<DiskVersion> versions = this.reloadDiskVersions();
        if (versions != null) {
            return versions.get(versions.size() - 1).getVersion();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVersion(String ver) throws SQLException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, IOException {
        log.info("Attempting to set DB version to '" + ver + "'");
        Version version = new Version(ver);
        DBMLock lock = null;
        try {
            lock = this.dbmdata.acquireLock(DBM, this.LOCK_TIMEOUT);
            this.dbmdata.setVersion(version.toString(), MANUAL, null, false, null, null, null);
        }
        catch (Exception ex) {
            try {
                log.error("Error setting DB Version", (Throwable)ex);
            }
            catch (Throwable throwable) {
                this.dbmdata.releaseLock(lock);
                throw throwable;
            }
            this.dbmdata.releaseLock(lock);
        }
        this.dbmdata.releaseLock(lock);
        this.showVersionStatus();
    }

    public void reapply(String version) throws SQLException, InterruptedException {
        DiskVersion diskVer = this.findDiskVersion(version);
        ReapplyAction action = new ReapplyAction(this, diskVer);
        this.executeActionWithLock(action);
    }

    public void rollback(String version) throws SQLException, IOException, InterruptedException {
        DiskVersion diskVer = this.findDiskVersion(version);
        RollbackDiskAction action = new RollbackDiskAction(this, diskVer);
        this.executeActionWithLock(action);
    }

    public void apply(String version) throws SQLException, IOException, InterruptedException {
        DiskVersion diskVer = this.findDiskVersion(version);
        ApplyAction action = new ApplyAction(this, diskVer);
        this.executeActionWithLock(action);
    }

    private DiskVersion findDiskVersion(String ver) {
        DiskVersion diskVer = null;
        for (DiskVersion diskVersion : this.diskVersions) {
            if (!diskVersion.getVersion().toString().equals(ver)) continue;
            diskVer = diskVersion;
            break;
        }
        return diskVer;
    }

    private DBVersion findLatestDBVersion(String ver) {
        DBVersion dbv = null;
        for (DBVersion v : this.dbVersions) {
            if (!v.getVersion().toString().equals(ver)) continue;
            dbv = v;
        }
        return dbv;
    }

    DBVersion findLatestDBApply(String ver) {
        DBVersion dbv = null;
        for (DBVersion v : this.dbVersions) {
            if (!v.getVersion().toString().equals(ver) || !v.getAction().equals(APPLY)) continue;
            dbv = v;
        }
        return dbv;
    }

    public DBVersion findPreviousDBApply(Version version) {
        Object dbv = null;
        for (int i = this.dbVersions.size() - 1; i >= 0; --i) {
            DBVersion v = this.dbVersions.get(i);
            if (v.getVersion().compareTo(version) >= 0 || !v.getAction().equals(APPLY)) continue;
            return v;
        }
        return null;
    }

    public List<Action> recommendUpdateActions() throws IOException, SQLException {
        ArrayList<Action> actions = new ArrayList<Action>();
        Version dbVersionNum = this.getCurrentDBVersion();
        Version diskVersionNum = this.getMaxDiskVersion();
        if (diskVersionNum == null) {
            log.info("DiskVersions are null. Cannot recommend update.");
            return null;
        }
        if (dbVersionNum == null) {
            log.warn("DBM DB Version is null - schema not initialized or out of date.  Recommend: init.");
            dbVersionNum = new Version("-1");
            actions.add(new InitAction(this));
        }
        DiskVersion diskVersion = this.findDiskVersion(diskVersionNum.toString());
        DBVersion dbVersion = null;
        if (!dbVersionNum.equals(new Version("-1"))) {
            dbVersion = this.findLatestDBVersion(dbVersionNum.toString());
        }
        if (diskVersionNum.equals(dbVersionNum)) {
            DBVersion latestApply = this.findLatestDBApply(dbVersion.getVersion().toString());
            if (latestApply != null) {
                if (!diskVersion.getChecksum().equals(latestApply.getFileChecksum())) {
                    log.warn("Disk Version " + diskVersion.getVersion() + " checksum(" + diskVersion.getChecksum() + ") does not match DB Version " + latestApply.getVersion() + " checksum(" + latestApply.getFileChecksum() + ")");
                    actions.add(new ReapplyAction(this, diskVersion));
                } else {
                    log.info("Disk and Database versions are in sync, checkums match");
                }
            } else {
                log.warn("Cannot find latest APPLY of " + dbVersion.getVersion());
                log.info("Disk and database versions are the same, though cannot compare checksums.");
            }
        } else if (diskVersionNum.compareTo(dbVersionNum) > 0) {
            for (int i = 0; i < this.diskVersions.size(); ++i) {
                DiskVersion dv = this.diskVersions.get(i);
                if (dv.getVersion().compareTo(dbVersionNum) <= 0) continue;
                actions.add(new ApplyAction(this, dv));
            }
        } else {
            HashSet<Version> rbv = new HashSet<Version>();
            for (int i = this.dbVersions.size() - 1; i >= 0; --i) {
                DBVersion dv = this.dbVersions.get(i);
                if (dv.getVersion().compareTo(diskVersionNum) <= 0) continue;
                DBVersion ldv = this.findLatestDBApply(dv.getVersion().toString());
                log.debug("Version " + dv.getVersion());
                log.debug("   v:" + dv.getApplyDate() + "  / " + dv.getId());
                log.debug("   l:" + ldv.getApplyDate() + "  / " + ldv.getId() + " " + ldv.getVersion());
                AbstractAction action = null;
                action = ldv.getRollback() != false ? new RollbackDBAction(this, ldv) : new ManualAction(this, "RollbackManual(" + ldv.getVersion() + ")");
                log.debug("   " + action);
                if (rbv.contains(ldv.getVersion())) continue;
                actions.add(action);
                rbv.add(ldv.getVersion());
            }
        }
        return actions;
    }

    public void executeActionWithLock(Action a) throws SQLException, InterruptedException {
        ArrayList<Action> actions = new ArrayList<Action>(1);
        actions.add(a);
        this.executeActionsWithLock(actions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeActionsWithLock(List<Action> actions) throws SQLException, InterruptedException {
        log.info("Executing " + actions.size() + " actions.");
        StringBuilder actionpath = new StringBuilder();
        Action first = actions.get(0);
        if (first instanceof InitAction) {
            log.info("First Action is InitDB, executing before lock");
            first.execute();
            actionpath.append(first.toString());
            actions.remove(0);
        }
        DBMLock lock = null;
        try {
            lock = this.dbmdata.acquireLock(DBM, this.LOCK_TIMEOUT);
            log.debug("Obtained " + lock);
            for (Action action : actions) {
                boolean success = action.execute();
                if (actionpath.length() > 0) {
                    actionpath.append("->");
                }
                actionpath.append(action.toString() + ": " + (success ? "Success" : "FAIL"));
            }
        }
        finally {
            if (lock != null) {
                log.debug("Releasing " + lock);
                this.dbmdata.releaseLock(lock);
            }
        }
        log.info(actionpath.toString());
        this.reloadDBVersions();
    }

    public void updateAll() throws SQLException, IOException, InterruptedException {
        List<Action> actions = this.recommendUpdateActions();
        this.executeActionsWithLock(actions);
    }

    public Version getCurrentDBVersion() throws SQLException {
        this.reloadDBVersions();
        Version currentVersion = null;
        log.debug("Getting Current DB Version");
        try {
            DBVersion current = this.dbmdata.getCurrentVersion();
            currentVersion = current != null ? current.getVersion() : new Version("-1");
        }
        catch (Exception ex) {
            log.info("Error getting current Version of database.");
        }
        return currentVersion;
    }

    public DBMLock getExistingLock() throws SQLException {
        return this.dbmdata.selectLock(DBM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeStatement(SQLStatement sql) throws SQLException {
        log.info("Executing " + sql.getSql());
        boolean success = false;
        int rows = -1;
        String err = null;
        Statement state = null;
        try {
            Connection con = this.conInfo.getDefaultConnection();
            state = con.createStatement();
            rows = state.executeUpdate(sql.getSql());
            success = true;
        }
        catch (Exception ex) {
            try {
                log.error("Error executing\n " + sql.getSql(), (Throwable)ex);
                String stack = DebugUtils.stackString(ex);
                if (stack.length() > 4000) {
                    stack = stack.substring(0, 4000);
                }
                err = stack;
            }
            catch (Throwable throwable) {
                DBUtils.close(state);
                throw throwable;
            }
            DBUtils.close(state);
        }
        DBUtils.close(state);
        this.dbmdata.logStatement(sql, success, rows, err);
        return success;
    }

    public DBMLock lock() throws InterruptedException, SQLException {
        return this.dbmdata.acquireLock(DBM, this.LOCK_TIMEOUT);
    }

    public void unlock(DBMLock lock) throws SQLException {
        log.info("Attempting to release " + lock);
        this.dbmdata.releaseLock(lock);
    }

    public void forceUnlock(String id) throws SQLException {
        log.info("Attempting to force release any '" + id + "' lock.");
        this.dbmdata.releaseLock(id);
    }
}

