/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.db.jsql.cli;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import jline.console.completer.Completer;
import net.jmatrix.db.common.DBUtils;
import net.jmatrix.db.common.console.SysConsole;
import net.jmatrix.db.common.console.TextConsole;
import net.jmatrix.db.jsql.JSQL;
import net.jmatrix.db.jsql.cli.LineModeProcessor;
import net.jmatrix.db.jsql.formatters.RSFormatter;

public class SQLProcessor
implements LineModeProcessor {
    static final TextConsole console = SysConsole.getConsole();
    JSQL jsql = null;
    StringBuilder sqlbuffer = new StringBuilder();

    public SQLProcessor(JSQL j) {
        this.jsql = j;
    }

    @Override
    public String prompt() {
        return "JSQL.$>";
    }

    @Override
    public LineModeProcessor processLine(String line) {
        if ((line = line.replaceAll("\\s+$", "")).endsWith(";")) {
            this.sqlbuffer.append(line);
            this.execute(this.sqlbuffer.toString());
            this.sqlbuffer.delete(0, this.sqlbuffer.length());
            return null;
        }
        this.sqlbuffer.append(line + "\n");
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void execute(String sql) {
        block13: {
            if (!this.jsql.isConnected()) {
                console.warn("Not Connected.");
                return;
            }
            if (sql.endsWith(";")) {
                sql = sql.substring(0, sql.length() - 1);
            }
            console.debug("SQL \n" + sql);
            Statement state = null;
            ResultSet rs = null;
            long start = System.currentTimeMillis();
            try {
                state = this.jsql.getConnection().createStatement();
                boolean results = state.execute(sql);
                if (results) {
                    console.debug("execute returns " + results);
                    rs = state.getResultSet();
                    try {
                        RSFormatter formatter = this.jsql.getFormatter();
                        console.println(formatter.format(rs));
                    }
                    catch (Exception exx) {
                        console.error("Error formatting results", exx);
                    }
                } else {
                    int rows = state.getUpdateCount();
                    console.info("updated " + rows + " rows.");
                }
                DBUtils.close(null, state, rs);
            }
            catch (SQLException ex) {
                console.warn("Error executing sql", ex);
                break block13;
            }
            catch (Exception ex2) {
                console.error("Error exeuging sql", ex2);
                break block13;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                DBUtils.close(null, state, rs);
                long et = System.currentTimeMillis() - start;
                console.info("sql took " + et + "ms");
            }
            long et = System.currentTimeMillis() - start;
            console.info("sql took " + et + "ms");
        }
    }

    @Override
    public Collection<Completer> getCompleters() {
        return null;
    }
}

