/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.db.jsql.cli;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jline.console.completer.Completer;
import net.jmatrix.db.common.DBUtils;
import net.jmatrix.db.common.console.SysConsole;
import net.jmatrix.db.common.console.TextConsole;
import net.jmatrix.db.jsql.JSQL;
import net.jmatrix.db.jsql.cli.LineModeProcessor;
import net.jmatrix.db.jsql.formatters.RSFormatter;

public class PreparedStatementProcessor
implements LineModeProcessor {
    static final TextConsole console = SysConsole.getConsole();
    JSQL jsql = null;
    String sp = null;
    List<String> arguments = new ArrayList<String>();
    int argumentCount = 0;
    int pointer = 0;

    public PreparedStatementProcessor(JSQL j) {
        this.jsql = j;
        console.info("Syntax: ");
        console.info("   {call proc_name(?, ?)}");
    }

    @Override
    public String prompt() {
        if (this.pointer == 0) {
            return "JSQL.PS>";
        }
        return "JSQL.PS{" + this.pointer + "}>";
    }

    private static int count(String s, char c) {
        char[] ch;
        int count = 0;
        for (char x : ch = s.toCharArray()) {
            if (x != c) continue;
            ++count;
        }
        return count;
    }

    @Override
    public LineModeProcessor processLine(String line) {
        if (this.pointer == 0) {
            this.sp = line;
            this.argumentCount = PreparedStatementProcessor.count(this.sp, '?');
        } else {
            this.arguments.add(line);
        }
        ++this.pointer;
        if (this.pointer > this.argumentCount) {
            this.execute();
            return null;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void execute() {
        long start;
        ResultSet rs;
        PreparedStatement state;
        block12: {
            if (!this.jsql.isConnected()) {
                console.warn("Not Connected.");
                return;
            }
            console.debug("SQL \n" + this.sp);
            if (this.sp.trim().length() == 0) {
                console.info("No Procecure Specified.");
                return;
            }
            state = null;
            rs = null;
            start = System.currentTimeMillis();
            try {
                state = this.jsql.getConnection().prepareStatement(this.sp);
                for (int i = 0; i < this.arguments.size(); ++i) {
                    state.setObject(i + 1, this.arguments.get(i));
                }
                boolean results = state.execute();
                if (results) {
                    console.debug("execute returns " + results);
                    rs = state.getResultSet();
                    try {
                        RSFormatter formatter = this.jsql.getFormatter();
                        console.println(formatter.format(rs));
                    }
                    catch (Exception exx) {
                        console.error("Error formatting results", exx);
                    }
                    break block12;
                }
                int rows = state.getUpdateCount();
                console.info("updated " + rows + " rows.");
            }
            catch (SQLException ex) {
                console.warn("Error executing sql", ex);
                DBUtils.close(null, state, rs);
                long et = System.currentTimeMillis() - start;
                console.info("sql took " + et + "ms");
            }
            catch (Exception ex2) {
                console.error("Error exeuging sql", ex2);
                {
                    catch (Throwable throwable) {
                        DBUtils.close(null, state, rs);
                        long et = System.currentTimeMillis() - start;
                        console.info("sql took " + et + "ms");
                        throw throwable;
                    }
                }
                DBUtils.close(null, state, rs);
                long et = System.currentTimeMillis() - start;
                console.info("sql took " + et + "ms");
            }
        }
        DBUtils.close(null, state, rs);
        long et = System.currentTimeMillis() - start;
        console.info("sql took " + et + "ms");
    }

    @Override
    public Collection<Completer> getCompleters() {
        return null;
    }
}

