/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.db.jsql.cli;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import jline.console.completer.Completer;
import net.jmatrix.db.common.console.SysConsole;
import net.jmatrix.db.common.console.TextConsole;
import net.jmatrix.db.drivers.DriverMap;
import net.jmatrix.db.jsql.JSQL;
import net.jmatrix.db.jsql.cli.LineModeProcessor;

public class ConnectProcessor
implements LineModeProcessor {
    static final TextConsole console = SysConsole.getConsole();
    static final String DRIVER = "driver";
    static final String URL = "url";
    static final String USER = "username";
    static final String PASS = "password";
    JSQL jsql = null;
    static String[] prompts = new String[]{"driver", "url", "username", "password"};
    static String[] defaults = new String[]{"oracle.jdbc.driver.OracleDriver", "", "", ""};
    int pointer = 0;
    String prompt = null;
    String def = null;
    Map<String, String> values = new HashMap<String, String>();

    public ConnectProcessor(JSQL j, String line) {
        this.jsql = j;
        StringBuilder sb = new StringBuilder();
        sb.append("Known Drivers(not limited to these):\n");
        for (String driver : DriverMap.drivers) {
            sb.append("   " + driver + "\n");
        }
        console.println(sb.toString());
    }

    @Override
    public String prompt() {
        this.prompt = prompts[this.pointer];
        this.def = defaults[this.pointer];
        if (this.prompt.startsWith(PASS) && this.def != null) {
            this.def = this.def.replaceAll(".", "\\*");
        }
        ++this.pointer;
        return this.prompt + " [" + this.def + "]>";
    }

    @Override
    public LineModeProcessor processLine(String line) {
        if ((line = line.trim()).length() == 0) {
            this.values.put(this.prompt, this.def);
        } else {
            this.values.put(this.prompt, line);
            ConnectProcessor.defaults[this.pointer - 1] = line;
        }
        if (this.pointer == prompts.length) {
            this.connect();
            return null;
        }
        return this;
    }

    void connect() {
        String user = this.values.get(USER);
        String url = this.values.get(URL);
        try {
            this.jsql.connect(this.values.get(DRIVER), url, user, this.values.get(PASS));
        }
        catch (Exception ex) {
            console.error("Error connecting to " + user + " at " + url, ex);
        }
    }

    @Override
    public Collection<Completer> getCompleters() {
        return null;
    }
}

