/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.db.common;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public final class PerfTrack {
    static ThreadLocal<Item> threadLocalCurrent = new ThreadLocal();

    public static void start(Method m) {
        String s = PerfTrack.getMethodString(m);
        PerfTrack.start(s);
    }

    public static void start(String x) {
        if (x == null) {
            throw new NullPointerException("Null PerfTrack name.  Cannot perftrack null.");
        }
        Item current = threadLocalCurrent.get();
        if (current == null) {
            current = new Item(x, null);
            current.start();
            threadLocalCurrent.set(current);
        } else {
            Item child = new Item(x, current);
            child.start();
            threadLocalCurrent.set(child);
        }
    }

    public static void stop(Method m) {
        String s = PerfTrack.getMethodString(m);
        PerfTrack.stop(s);
    }

    private static final String getMethodString(Method m) {
        String classname = m.getDeclaringClass().getName();
        classname = classname.substring(classname.lastIndexOf(".") + 1);
        return classname + "." + m.getName();
    }

    public static void stop(String x) {
        if (x == null) {
            throw new NullPointerException("Null PerfTrack name.  Cannot perftrack null.");
        }
        Item current = threadLocalCurrent.get();
        if (current == null) {
            System.out.println("Stopping, but current is null??");
        } else if (current.getName() != null && current.getName().equals(x)) {
            current.stop();
            Item parent = current.getParent();
            if (parent != null) {
                threadLocalCurrent.set(parent);
            }
        } else {
            System.out.println("Stopping '" + x + "' but current is '" + current.getName() + "'");
        }
    }

    public static String reportAndClear() {
        String s = PerfTrack.toString(0);
        PerfTrack.clear();
        return s;
    }

    public static final boolean hasData() {
        return threadLocalCurrent.get() != null;
    }

    public static void clear() {
        threadLocalCurrent.remove();
    }

    public static boolean isCurrentRootAndComplete() {
        Item current = threadLocalCurrent.get();
        return current != null && current.getParent() == null && current.isDone();
    }

    public static String toString(int depth) {
        Item current = threadLocalCurrent.get();
        if (current != null) {
            if (current.getParent() == null) {
                return current.toString(depth);
            }
            Item root = current.findRoot();
            return root.toString(depth);
        }
        return "PerfTrack: no data?";
    }

    static final class Item {
        String name;
        int callCount = 0;
        Item parent = null;
        long start = 0L;
        long stop = 0L;
        long et = 0L;
        List<Item> children = new ArrayList<Item>();

        public Item(String n, Item p) {
            this.name = n;
            this.parent = p;
            ++this.callCount;
            if (this.parent != null) {
                this.parent.addChild(this);
            }
        }

        public void start() {
            this.start = System.currentTimeMillis();
        }

        public void stop() {
            this.stop = System.currentTimeMillis();
            this.et = this.stop - this.start;
        }

        public List<Item> getChildren() {
            return this.children;
        }

        public String getName() {
            return this.name;
        }

        public Item getParent() {
            return this.parent;
        }

        public String toString() {
            return "PTItem(" + this.name + ", start=" + this.start + ", stop=" + this.stop + ", parent=" + this.parent + ")";
        }

        public boolean hasChildren() {
            return this.children.size() > 0;
        }

        public final boolean isDone() {
            return this.stop != 0L;
        }

        public final long getEt() {
            if (this.stop == 0L) {
                return System.currentTimeMillis() - this.start;
            }
            return this.et;
        }

        public void addChild(Item i) {
            if (this.children.size() > 0) {
                Item lastChild = this.children.get(this.children.size() - 1);
                if (i.getName().equals(lastChild.getName())) {
                    ++lastChild.callCount;
                    lastChild.et = i.et;
                } else {
                    this.children.add(i);
                }
            } else {
                this.children.add(i);
            }
        }

        public Item findRoot() {
            if (this.parent == null) {
                return this;
            }
            return this.parent.findRoot();
        }

        public String toString(int depth) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < depth; ++i) {
                sb.append("  ");
            }
            long localstop = this.stop;
            String timesuffix = null;
            if (localstop == 0L) {
                localstop = System.currentTimeMillis();
                timesuffix = "UF";
            }
            sb.append(this.name + " " + (this.callCount > 1 ? "(" + this.callCount + ") " : "") + (localstop - this.start) + (timesuffix == null ? "" : "(UF)") + "ms\n");
            if (this.children.size() > 0) {
                long unaccounted = this.et;
                for (Item child : this.children) {
                    unaccounted -= child.getEt();
                    sb.append(child.toString(depth + 1));
                }
                for (int i = 0; i < depth + 1; ++i) {
                    sb.append("  ");
                }
                sb.append("Other " + unaccounted + "ms\n");
            }
            return sb.toString();
        }
    }
}

