/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.db.common;

public class ArgParser {
    String[] args = null;

    public ArgParser(String[] a) {
        this.args = a;
    }

    public String getStringArg(String key) {
        return this.getStringArg(key, null);
    }

    public String getStringArg(String key, String def) {
        for (int i = 0; i < this.args.length; ++i) {
            String arg = this.args[i];
            if (arg.equalsIgnoreCase(key) && this.args.length >= i + 2) {
                return this.args[i + 1].trim();
            }
            if (!arg.startsWith(key)) continue;
            return arg.substring(key.length()).trim();
        }
        return def;
    }

    public int size() {
        return this.args.length;
    }

    public String getLastArg() {
        if (this.args.length > 0) {
            return this.args[this.args.length - 1];
        }
        return null;
    }

    public Integer getIntegerArg(String key) {
        String str = this.getStringArg(key);
        if (str == null || str.trim().length() <= 0) {
            return null;
        }
        Integer val = null;
        try {
            int i = Integer.parseInt(str.trim());
            val = new Integer(i);
        }
        catch (NumberFormatException ex) {
            System.out.println("NumberFormatException reading " + key + " from " + "args.");
        }
        return val;
    }

    public int getIntArg(String key, int def) {
        Integer i = this.getIntegerArg(key);
        if (i == null) {
            return def;
        }
        return i;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.args.length; ++i) {
            sb.append("  " + i + ": '" + this.args[i] + "'\n");
        }
        return sb.toString();
    }

    public boolean getBooleanArg(String key) {
        for (int i = 0; i < this.args.length; ++i) {
            String arg = this.args[i];
            if (!arg.equalsIgnoreCase(key)) continue;
            return true;
        }
        return false;
    }

    public boolean getBooleanArg(String key, boolean def) {
        for (int i = 0; i < this.args.length; ++i) {
            String arg = this.args[i];
            if (!arg.equalsIgnoreCase(key)) continue;
            return true;
        }
        return def;
    }
}

