/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.db.schema.data.v2;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import net.jmatrix.db.common.ClassLogFactory;
import net.jmatrix.db.common.ConnectionInfo;
import net.jmatrix.db.common.DBUtils;
import net.jmatrix.db.common.DebugUtils;
import net.jmatrix.db.common.SQLUtil;
import net.jmatrix.db.common.StreamUtil;
import net.jmatrix.db.common.Version;
import net.jmatrix.db.schema.DBMException;
import net.jmatrix.db.schema.DBVersion;
import net.jmatrix.db.schema.SQLStatement;
import net.jmatrix.db.schema.data.v2.DBMLock;
import net.jmatrix.db.schema.data.v2.GenericSchemaChecksum;
import org.slf4j.Logger;

public class DBMData {
    private static Logger log = ClassLogFactory.getLog();
    static String DBM_LOG = "DBM_LOG";
    static String DBM_VERSIONS = "DBM_VERSIONS";
    Connection con = null;
    ConnectionInfo conInfo = null;
    public static int LOCK_CHECK_INTERVAL = 2500;

    public DBMData(ConnectionInfo ci) throws SQLException {
        this.conInfo = ci;
        if (!ci.isConnected()) {
            ci.initDefaultConnection();
        }
        this.con = ci.getDefaultConnection();
    }

    public void drop() throws SQLException {
    }

    public void init() throws SQLException, IOException {
        if (!this.tableExists(DBM_VERSIONS)) {
            this.createV2();
        } else if (this.isV1Schema()) {
            log.info("DBM Schema is V1.  Migrating.");
            this.migrate();
        }
        if (!this.columnExists(DBM_VERSIONS, "ROLLBACK_SQL")) {
            log.info("DBMSchema updating to 2.1");
            this.migrate21();
        }
        log.info("DBM Schema is available.");
    }

    void createV2() throws IOException, SQLException {
        String v2clean = StreamUtil.readToString(this.getClass().getResourceAsStream("v2_clean.sql"));
        v2clean = SQLUtil.stripSQLComments(v2clean);
        List<String> sqls = SQLUtil.splitSQL(v2clean, ";");
        for (String sql : sqls) {
            log.info("Executing \n" + DebugUtils.indent(sql, 3));
            int rows = DBUtils.executeUpdate(this.con, sql);
            log.info(rows + " rows.");
            log.info("============================");
        }
        SimpleDateFormat df = new SimpleDateFormat("dd.MMM.yyyy HH:mm:ss");
        this.setVersion("0", "INITIAL", null, false, null, "Initialiation at " + df.format(new Date()), null);
    }

    void migrate() throws IOException, SQLException {
        String v1back = StreamUtil.readToString(this.getClass().getResourceAsStream("v1_back.sql"));
        v1back = SQLUtil.stripSQLComments(v1back);
        String v2clean = StreamUtil.readToString(this.getClass().getResourceAsStream("v2_clean.sql"));
        v2clean = SQLUtil.stripSQLComments(v2clean);
        List<String> sqls = SQLUtil.splitSQL(v1back, ";");
        sqls.addAll(SQLUtil.splitSQL(v2clean, ";"));
        for (String sql : sqls) {
            log.info("Executing \n" + DebugUtils.indent(sql, 3));
            int rows = DBUtils.executeUpdate(this.con, sql);
            log.info(rows + " rows.");
            log.info("============================");
        }
        this.restoreV1Data();
        String v1drop = StreamUtil.readToString(this.getClass().getResourceAsStream("v1_drop.sql"));
        v1drop = SQLUtil.stripSQLComments(v1drop);
        sqls = SQLUtil.splitSQL(v1drop, ";");
        for (String sql : sqls) {
            log.info("Executing \n" + DebugUtils.indent(sql, 3));
            int rows = DBUtils.executeUpdate(this.con, sql);
            log.info(rows + " rows.");
            log.info("============================");
        }
    }

    void migrate21() throws IOException, SQLException {
        String migrate = StreamUtil.readToString(this.getClass().getResourceAsStream("v2.1_alter.sql"));
        migrate = SQLUtil.stripSQLComments(migrate);
        List<String> sqls = SQLUtil.splitSQL(migrate, ";");
        for (String sql : sqls) {
            log.info("Executing \n" + DebugUtils.indent(sql, 3));
            int rows = DBUtils.executeUpdate(this.con, sql);
            log.info(rows + " rows.");
            log.info("============================");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreV1Data() throws SQLException {
        Timestamp ts;
        int count;
        log.info("Restoring v1 data");
        PreparedStatement read = null;
        PreparedStatement write = null;
        ResultSet rs = null;
        try {
            read = this.con.prepareStatement("select id, tstamp, filepath, status, num_rows, sql, error from dbm_log_v1");
            write = this.con.prepareStatement("insert into dbm_log (id, tstamp, filepath, success, num_rows, sql, error)\nvalues (?, ?, ?, ?, ?, ?, ?)");
            rs = read.executeQuery();
            count = 0;
            while (rs.next()) {
                ++count;
                write.clearParameters();
                write.setString(1, rs.getString(1));
                ts = rs.getTimestamp(2);
                write.setLong(2, ts == null ? 0L : ts.getTime());
                write.setString(3, rs.getString(3));
                write.setString(4, rs.getString(4));
                write.setInt(5, rs.getInt(5));
                write.setString(6, rs.getString(6));
                write.setString(7, rs.getString(7));
                write.execute();
            }
            log.info("Restored " + count + " rows to dbm_log");
        }
        catch (Throwable throwable) {
            DBUtils.close(rs);
            DBUtils.close(read);
            DBUtils.close(write);
            throw throwable;
        }
        DBUtils.close(rs);
        DBUtils.close(read);
        DBUtils.close(write);
        try {
            read = this.con.prepareStatement("select id, tstamp, filepath, action, hostname, username, version from dbm_versions_v1");
            write = this.con.prepareStatement("insert into dbm_versions(id, tstamp, filepath, action, hostname, hostuser, version)\nvalues (?, ?, ?, ?, ?, ?, ?)");
            rs = read.executeQuery();
            count = 0;
            while (rs.next()) {
                ++count;
                write.clearParameters();
                write.setString(1, rs.getString(1));
                ts = rs.getTimestamp(2);
                write.setLong(2, ts == null ? 0L : ts.getTime());
                write.setString(3, rs.getString(3));
                write.setString(4, rs.getString(4));
                write.setString(5, rs.getString(5));
                write.setString(6, rs.getString(6));
                write.setString(7, rs.getString(7));
                write.execute();
            }
            log.info("Restored " + count + " rows to dbm_versions");
        }
        finally {
            DBUtils.close(rs);
            DBUtils.close(read);
            DBUtils.close(write);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isV1Schema() throws SQLException {
        boolean bl;
        Statement state = null;
        ResultSet rs = null;
        try {
            state = this.con.createStatement();
            rs = state.executeQuery("select * from " + DBM_VERSIONS);
            ResultSetMetaData rsmd = rs.getMetaData();
            int cols = rsmd.getColumnCount();
            bl = cols == 8;
        }
        catch (Throwable throwable) {
            DBUtils.close(null, state, rs);
            throw throwable;
        }
        DBUtils.close(null, state, rs);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    boolean isV2Schema() throws SQLException {
        Statement state = null;
        ResultSet rs = null;
        state = this.con.createStatement();
        rs = state.executeQuery("select * from " + DBM_VERSIONS);
        ResultSetMetaData rsmd = rs.getMetaData();
        int cols = rsmd.getColumnCount();
        boolean bl = cols == 12;
        DBUtils.close(null, state, rs);
        return bl;
        {
            catch (SQLException ex) {
                boolean bl2;
                try {
                    log.warn("Got error checking schema version: " + ex);
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    DBUtils.close(null, state, rs);
                    throw throwable;
                }
                DBUtils.close(null, state, rs);
                return bl2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    boolean isV21Schema() throws SQLException {
        Statement state = null;
        ResultSet rs = null;
        state = this.con.createStatement();
        rs = state.executeQuery("select * from " + DBM_VERSIONS);
        ResultSetMetaData rsmd = rs.getMetaData();
        int cols = rsmd.getColumnCount();
        boolean bl = cols == 13;
        DBUtils.close(null, state, rs);
        return bl;
        {
            catch (SQLException ex) {
                boolean bl2;
                try {
                    log.warn("Got error checking schema version: " + ex);
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    DBUtils.close(null, state, rs);
                    throw throwable;
                }
                DBUtils.close(null, state, rs);
                return bl2;
            }
        }
    }

    public boolean isDBMSchemaCurrent() throws SQLException {
        return this.isV21Schema();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean tableExists(String tablename) throws SQLException {
        ResultSet rs;
        block2: {
            boolean bl;
            DatabaseMetaData dbmd = null;
            rs = null;
            log.debug("Looking for table " + tablename);
            try {
                dbmd = this.con.getMetaData();
                rs = dbmd.getTables(null, null, tablename, new String[]{"TABLE"});
                if (!rs.next()) break block2;
                String table = rs.getString("TABLE_NAME");
                log.debug("Found table: " + table);
                bl = true;
            }
            catch (Throwable throwable) {
                DBUtils.close(rs);
                throw throwable;
            }
            DBUtils.close(rs);
            return bl;
        }
        DBUtils.close(rs);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean columnExists(String tablename, String colname) throws SQLException {
        boolean bl;
        DatabaseMetaData dbmd = null;
        ResultSet rs = null;
        log.debug("Looking for column " + colname + " in table " + tablename);
        try {
            dbmd = this.con.getMetaData();
            rs = dbmd.getColumns(null, null, tablename, null);
            while (rs.next()) {
                String table = rs.getString("TABLE_NAME");
                String column = rs.getString("COLUMN_NAME");
                if (!column.equalsIgnoreCase(colname)) break block4;
                log.debug("Found column: " + table + "." + column);
                bl = true;
            }
        }
        catch (Throwable throwable) {
            DBUtils.close(rs);
            throw throwable;
        }
        {
            block4: {
                DBUtils.close(rs);
                return bl;
            }
            continue;
        }
        DBUtils.close(rs);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logStatement(SQLStatement sqlState, boolean success, int rows, String err) throws SQLException {
        String sql = "insert into " + DBM_LOG + " values(?, ?, ?, ?, ?, ?, ?, ?)";
        log.debug("Log sql: " + sql);
        PreparedStatement state = null;
        try {
            state = this.con.prepareStatement(sql);
            state.setString(1, UUID.randomUUID().toString());
            state.setString(2, sqlState.getVersion().toString());
            state.setLong(3, System.currentTimeMillis());
            state.setString(4, sqlState.getFile());
            state.setString(5, success ? "T" : "F");
            state.setInt(6, rows);
            state.setString(7, sqlState.getSql());
            state.setString(8, err);
            state.execute();
        }
        catch (Throwable throwable) {
            DBUtils.close(state);
            throw throwable;
        }
        DBUtils.close(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVersion(String version, String action, String path, boolean rollback, String checksum, String notes, String rollbackSql) throws SQLException {
        String sql = "insert into " + DBM_VERSIONS + " values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement state = null;
        try {
            state = this.con.prepareStatement(sql);
            state.setString(1, UUID.randomUUID().toString());
            state.setLong(2, System.currentTimeMillis());
            state.setString(3, path);
            state.setString(4, action);
            state.setString(5, rollback ? "T" : "F");
            state.setString(6, DBMData.getHost());
            state.setString(7, DBMData.getUser());
            state.setString(8, this.conInfo.getUsername());
            state.setString(9, version);
            state.setString(10, checksum);
            state.setString(11, this.schemaChecksum());
            state.setString(12, notes);
            state.setString(13, rollbackSql);
            state.execute();
        }
        catch (Throwable throwable) {
            DBUtils.close(state);
            throw throwable;
        }
        DBUtils.close(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBVersion getCurrentVersion() throws SQLException {
        ResultSet rs;
        Statement state;
        block3: {
            DBVersion dBVersion;
            String sql = "select * from " + DBM_VERSIONS + " where action <> 'LOCK' order by tstamp desc";
            log.debug("Getting current version with \n   " + sql);
            state = null;
            rs = null;
            try {
                state = this.con.createStatement();
                rs = state.executeQuery(sql);
                if (!rs.next()) break block3;
                dBVersion = DBMData.buildDBVersion(rs);
            }
            catch (Throwable throwable) {
                DBUtils.close(null, state, rs);
                throw throwable;
            }
            DBUtils.close(null, state, rs);
            return dBVersion;
        }
        DBVersion dBVersion = null;
        DBUtils.close(null, state, rs);
        return dBVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPreviousVersion() throws SQLException {
        ResultSet rs;
        Statement state;
        block3: {
            String string;
            String sql = "select version from " + DBM_VERSIONS + " where action <> 'LOCK' order by tstamp desc";
            log.debug("Getting current version with \n   " + sql);
            state = null;
            rs = null;
            try {
                state = this.con.createStatement();
                rs = state.executeQuery(sql);
                rs.next();
                if (!rs.next()) break block3;
                string = rs.getString(1);
            }
            catch (Throwable throwable) {
                DBUtils.close(null, state, rs);
                throw throwable;
            }
            DBUtils.close(null, state, rs);
            return string;
        }
        String string = null;
        DBUtils.close(null, state, rs);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DBVersion> getDBVersions() throws SQLException {
        ArrayList<DBVersion> arrayList;
        String sql = "select * from " + DBM_VERSIONS + " where action <> 'LOCK' order by tstamp";
        log.debug("Getting db versions with \n   " + sql);
        Statement state = null;
        ResultSet rs = null;
        try {
            state = this.con.createStatement();
            rs = state.executeQuery(sql);
            ArrayList<DBVersion> versions = new ArrayList<DBVersion>();
            while (rs.next()) {
                versions.add(DBMData.buildDBVersion(rs));
            }
            arrayList = versions;
        }
        catch (Throwable throwable) {
            DBUtils.close(null, state, rs);
            throw throwable;
        }
        DBUtils.close(null, state, rs);
        return arrayList;
    }

    private static final DBVersion buildDBVersion(ResultSet rs) throws SQLException {
        String rollback;
        DBVersion dbv = new DBVersion();
        dbv.setId(rs.getString("id"));
        dbv.setVersion(new Version(rs.getString("version")));
        dbv.setAction(rs.getString("action"));
        long l = rs.getLong("tstamp");
        dbv.setApplyDate(new Date(l));
        dbv.setHostname(rs.getString("hostname"));
        dbv.setHostuser(rs.getString("hostuser"));
        dbv.setDbuser(rs.getString("dbuser"));
        dbv.setDbChecksum(rs.getString("db_checksum"));
        dbv.setFileChecksum(rs.getString("file_checksum"));
        String rbs = rs.getString("rollback_sql");
        if (rbs != null) {
            ObjectMapper om = new ObjectMapper();
            try {
                List sql = (List)om.readValue(rbs, (TypeReference)new TypeReference<List<String>>(){});
                dbv.setRollbackSql(sql);
            }
            catch (IOException ex) {
                log.warn("Unable to parse sql from version '" + rbs + "'", ex);
            }
        }
        if ((rollback = rs.getString("rollback")) != null) {
            dbv.setRollback(rollback.equals("T"));
        }
        return dbv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String schemaChecksum() {
        GenericSchemaChecksum hasher = new GenericSchemaChecksum(this.conInfo);
        try {
            long checksum = hasher.calculateSchemaChecksum();
            String string = "" + checksum;
            return string;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String string = "error";
            return string;
        }
    }

    static String getHost() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (Exception ex) {
            return "unknown";
        }
    }

    static String getUser() {
        return System.getProperty("user.name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBMLock selectLock(String id) throws SQLException {
        ResultSet rs;
        PreparedStatement state;
        Connection con;
        block3: {
            DBMLock dBMLock;
            con = null;
            state = null;
            rs = null;
            String sql = "select * from " + DBM_VERSIONS + " where action='LOCK' and id=?";
            log.debug("selectLock(" + sql + ", id=" + id + ")");
            try {
                con = this.conInfo.connect();
                con.setAutoCommit(true);
                state = con.prepareStatement(sql);
                state.setString(1, id);
                rs = state.executeQuery();
                if (!rs.next()) break block3;
                dBMLock = DBMData.buildLock(rs);
            }
            catch (Throwable throwable) {
                DBUtils.close(con, state, rs);
                throw throwable;
            }
            DBUtils.close(con, state, rs);
            return dBMLock;
        }
        DBMLock dBMLock = null;
        DBUtils.close(con, state, rs);
        return dBMLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DBMLock createLock(String id, String notes) throws SQLException {
        Connection con = null;
        PreparedStatement state = null;
        ResultSet rs = null;
        String sql = "insert into " + DBM_VERSIONS + " (id, action, version, hostname, hostuser, tstamp, notes)\n" + "values (?, 'LOCK', 'LOCK', ?, ?, ?, ?)";
        log.debug("CreateLock(" + sql + ", id=" + id + ")");
        try {
            con = this.conInfo.connect();
            con.setAutoCommit(true);
            state = con.prepareStatement(sql);
            state.setString(1, id);
            state.setString(2, DBMData.getHost());
            state.setString(3, System.getProperty("user.name"));
            state.setLong(4, System.currentTimeMillis());
            state.setString(5, notes);
            int rows = state.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.close(con, state, rs);
            throw throwable;
        }
        DBUtils.close(con, state, rs);
        return this.selectLock(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteLock(String id) throws SQLException {
        Connection con = null;
        PreparedStatement state = null;
        ResultSet rs = null;
        String sql = "delete from " + DBM_VERSIONS + " where action='LOCK' and id=?";
        log.debug("deleteLock(" + sql + ", id=" + id + ")");
        try {
            con = this.conInfo.connect();
            con.setAutoCommit(true);
            state = con.prepareStatement(sql);
            state.setString(1, id);
            int rows = state.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.close(null, state, rs);
            throw throwable;
        }
        DBUtils.close(null, state, rs);
    }

    private static final DBMLock buildLock(ResultSet rs) throws SQLException {
        DBMLock lock = new DBMLock();
        lock.setId(rs.getString("id"));
        lock.setHost(rs.getString("hostname"));
        lock.setUser(rs.getString("hostuser"));
        lock.setTimestamp(rs.getLong("tstamp"));
        lock.setNotes(rs.getString("notes"));
        return lock;
    }

    public DBMLock acquireLock(String id, long millis) throws InterruptedException, SQLException {
        long start = System.currentTimeMillis();
        log.debug("Attempting to acquire lock '" + id + "'");
        DBMLock existing = this.selectLock(id);
        if (existing != null) {
            log.warn("Lock in use: " + existing + ", waiting " + millis + " to acquire lock.");
            Thread.sleep(LOCK_CHECK_INTERVAL);
        } else {
            log.debug("No lock appears at present.");
        }
        int count = 0;
        long et = System.currentTimeMillis() - start;
        DBMLock lock = null;
        while (lock == null && et < millis) {
            try {
                log.debug("Attempt " + ++count + " to obtain Lock '" + id + "', current wait=" + et);
                lock = this.createLock(id, null);
            }
            catch (Exception ex) {
                lock = null;
                log.debug("Cannot acquire lock: " + ex);
            }
            if (lock != null) {
                return lock;
            }
            Thread.sleep(LOCK_CHECK_INTERVAL);
            et = System.currentTimeMillis() - start;
        }
        et = System.currentTimeMillis() - start;
        DBMLock recent = this.selectLock(id);
        throw new DBMException("Unable to obtain lock id '" + id + "' in " + millis + "ms,  et=" + et + ". in use: " + (recent == null ? (existing == null ? "unknown" : existing.toString()) : recent.toString()));
    }

    public void releaseLock(DBMLock lock) throws SQLException {
        if (lock == null) {
            log.info("releaseLock called w/ null lock.");
            return;
        }
        this.releaseLock(lock.getId());
    }

    public void releaseLock(String ID) throws SQLException {
        log.debug("Releasing lock " + ID);
        this.deleteLock(ID);
    }

    static enum DBMVersion {
        NONE,
        V1,
        V2,
        V2_1;

    }
}

