/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.db.schema.data.v1;

import java.security.MessageDigest;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import net.jmatrix.db.common.DBUtils;
import net.jmatrix.db.common.Hex;
import net.jmatrix.db.common.console.SysConsole;
import net.jmatrix.db.common.console.TextConsole;
import net.jmatrix.db.schema.data.v1.SchemaHasher;

public class GenericSchemaHasher
implements SchemaHasher {
    static TextConsole console = SysConsole.getConsole();
    Connection con = null;
    List<String> configTables = null;
    List<String> tables = null;

    public GenericSchemaHasher(Connection c) {
        this.con = c;
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String calculateSchemaHash() throws Exception {
        String hash = null;
        long start = System.currentTimeMillis();
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.reset();
            this.add(this.con, digest, new String[]{"TABLE", "VIEW"});
            if (this.configTables != null) {
                for (String tablename : this.configTables) {
                    this.addRows(this.con, digest, tablename);
                }
            }
            hash = Hex.asHex(digest.digest());
        }
        catch (Throwable throwable) {
            long et = System.currentTimeMillis() - start;
            console.info("Calculated schema hash '" + hash + "' in " + et + "ms");
            throw throwable;
        }
        long et = System.currentTimeMillis() - start;
        console.info("Calculated schema hash '" + hash + "' in " + et + "ms");
        return hash;
    }

    void reset() {
        this.tables = new ArrayList<String>();
    }

    boolean ignoreTable(String tablename) {
        if (tablename == null) {
            return true;
        }
        return tablename.toUpperCase().matches("^DBM");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(Connection con, MessageDigest digest, String[] types) throws SQLException {
        DatabaseMetaData dbmd = con.getMetaData();
        ResultSet rs = null;
        try {
            con.getSchema();
            rs = dbmd.getTables(null, con.getSchema(), null, types);
            while (rs.next()) {
                String tableName = rs.getString("table_name");
                if (!this.ignoreTable(tableName)) {
                    this.tables.add(tableName.toUpperCase());
                    ResultSet rs2 = null;
                    console.info("Hashing Table Schema: " + tableName);
                    try {
                        rs2 = dbmd.getColumns(null, con.getSchema(), tableName, null);
                        while (rs2.next()) {
                            String cname = rs2.getString("column_name");
                            String tname = rs2.getString("type_name");
                            String size = rs2.getString("column_size");
                            digest.update(cname.getBytes());
                            digest.update(tname.getBytes());
                            digest.update(size.getBytes());
                        }
                    }
                    catch (Throwable throwable) {
                        DBUtils.close(rs2);
                        throw throwable;
                    }
                    DBUtils.close(rs2);
                    continue;
                }
                console.info("Ignoring " + tableName);
            }
        }
        catch (Throwable throwable) {
            DBUtils.close(rs);
            throw throwable;
        }
        DBUtils.close(rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRows(Connection con, MessageDigest digest, String tablename) throws SQLException {
        if (!this.tables.contains(tablename.toUpperCase())) {
            console.warn("Cannot find table '" + tablename + "' in known schema tables: " + this.tables);
            digest.update("TABLE_DOES_NOT_EXIST".getBytes());
            return;
        }
        String sql = "select * from " + tablename;
        console.info("hashing table " + tablename);
        Statement state = null;
        ResultSet rs = null;
        state = con.createStatement();
        rs = state.executeQuery(sql);
        ResultSetMetaData rsmd = rs.getMetaData();
        int cols = rsmd.getColumnCount();
        digest.update(("" + cols).getBytes());
        int count = 0;
        while (rs.next()) {
            ++count;
            for (int i = 1; i <= cols; ++i) {
                String val = rs.getString(i);
                if (val == null) {
                    digest.update("NULLVALUE".getBytes());
                    continue;
                }
                digest.update(val.getBytes());
            }
        }
        console.info("Updated hash with " + count + " rows x " + cols + " cols");
    }

    public List<String> getConfigTables() {
        return this.configTables;
    }

    public void setConfigTables(List<String> configTables) {
        this.configTables = configTables;
    }
}

