/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.db.jsql.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.jmatrix.db.common.ConnectionInfo;
import net.jmatrix.db.common.DotConfig;
import net.jmatrix.db.common.JSONUtil;

public class RecentConnections {
    static final String RECENT_CONNECTIONS = "recent.connections.json";
    int number = 20;
    List<ConnectionInfo> connections = new ArrayList<ConnectionInfo>();

    public void update(ConnectionInfo ci) {
        int index = this.connections.indexOf(ci);
        if (index != -1) {
            this.connections.set(index, ci);
        } else {
            this.connections.add(ci);
        }
        Collections.sort(this.connections);
        if (this.connections.size() > this.number) {
            this.connections.remove(this.connections.size() - 1);
        }
    }

    public ConnectionInfo get(int i) {
        return this.connections.get(i);
    }

    @JsonIgnore
    public ConnectionInfo getMostRecent() {
        if (this.connections != null && this.connections.size() > 0) {
            return this.connections.get(0);
        }
        return null;
    }

    public static RecentConnections load(String app) throws IOException {
        DotConfig dc = new DotConfig(app);
        String s = dc.read(RECENT_CONNECTIONS);
        if (s == null || s.length() == 0) {
            RecentConnections rc = new RecentConnections();
            rc.save(app);
            return rc;
        }
        return JSONUtil.read(s, RecentConnections.class);
    }

    public void save(String app) throws IOException {
        DotConfig dc = new DotConfig(app);
        dc.write(RECENT_CONNECTIONS, JSONUtil.write(this));
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public List<ConnectionInfo> getConnections() {
        return this.connections;
    }

    public void setConnections(List<ConnectionInfo> connections) {
        this.connections = connections;
    }
}

