/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.db.jsql.cli;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import jline.console.completer.Completer;
import jline.console.completer.StringsCompleter;
import net.jmatrix.db.common.ConnectionInfo;
import net.jmatrix.db.common.console.SysConsole;
import net.jmatrix.db.common.console.TextConsole;
import net.jmatrix.db.jsql.JSQL;
import net.jmatrix.db.jsql.cli.LineModeProcessor;
import net.jmatrix.db.schema.DBM;
import net.jmatrix.db.schema.action.Action;
import net.jmatrix.db.schema.data.v2.DBMLock;

public class DBMProcessor
implements LineModeProcessor {
    static TextConsole console = SysConsole.getConsole();
    DBM dbm = null;
    JSQL jsql = null;
    ConnectionInfo conInfo = null;
    String def = null;
    static final String DBM_PATH = "dbm.path";
    List<Completer> completers = new ArrayList<Completer>();
    DBMLock lock = null;
    static final String usage = "show \n   status: shows an overall status comparison of disk and db versions.\n   db.versions: shows the DBM history\n   disk.versions: shows versions from Disk\n   recommendations: shows schema update recommendations\n\ninit:      Initialize the DBM meta-data tables in the database.\nupdate:    Update DB to match disk version, applying any versions < current DB version.\napply    <version>: apply only verison requested\nrollback <version>: rollback only version requested\nreapply  <version>: rollback, then apply version requessted\n\nset\n   version <version>: sets DB version to value manually.\n\nexit: exit DBM mode\nquit: quit the application\n";

    public DBMProcessor(JSQL j) {
        this.jsql = j;
        this.conInfo = this.jsql.getConnectionInfo();
        if (this.conInfo.getProperties() != null) {
            this.def = this.conInfo.getProperties().get(DBM_PATH);
        }
        List<String> commands = Arrays.asList("update", "apply", "rollback", "reapply", "exit", "quit", "clear", "init", "lock", "unlock", "force-unlock", "show db.versions", "show disk.versions", "show status", "show recommendations", "show lock");
        StringsCompleter cc = new StringsCompleter(commands);
        this.completers.add(cc);
    }

    @Override
    public Collection<Completer> getCompleters() {
        return this.completers;
    }

    @Override
    public String prompt() {
        if (this.dbm == null) {
            return "JSQL.DBM - schema [" + this.def + "]>";
        }
        return "JSQL.DBM>";
    }

    @Override
    public LineModeProcessor processLine(String line) {
        String[] split = line.split(" ");
        String command = split[0];
        try {
            if (this.dbm == null) {
                String pathstring = null;
                pathstring = line.length() == 0 ? this.def : line;
                if (pathstring != null) {
                    console.info("DBM Disk Path: " + pathstring);
                    File path = new File(pathstring);
                    if (!(path.exists() && path.isDirectory() && path.canRead())) {
                        console.warn("Cannot find/read DBM Disk path at " + path.getAbsolutePath());
                    } else {
                        this.conInfo.setProperty(DBM_PATH, pathstring);
                        try {
                            this.jsql.getRecentConnections().save(JSQL.JSQL);
                        }
                        catch (Exception ex) {
                            console.warn("Error saving recent connections: " + ex);
                        }
                        this.dbm = new DBM(this.conInfo, path);
                        this.dbm.reloadDiskVersions();
                    }
                }
                if (this.dbm == null) {
                    this.dbm = new DBM(this.conInfo, null);
                    console.info("Creating DB only SchemaManager");
                }
                if (this.dbm.reloadDBVersions()) {
                    this.dbm.showVersionStatus();
                    this.showRecommendationsShort();
                    DBMLock lock = this.dbm.getExistingLock();
                    if (lock != null) {
                        console.warn("DBM System has existing lock.");
                        console.warn("   " + lock);
                    } else {
                        console.info("DBM not currently locked.");
                    }
                } else {
                    console.warn("Recommend: init dbm schema with 'init' command.");
                }
                return this;
            }
            block20 : switch (command) {
                case "exit": {
                    return null;
                }
                case "set": {
                    switch (split[1]) {
                        case "version": {
                            this.dbm.setVersion(split[2]);
                            break block20;
                        }
                    }
                    console.warn("Don't know how to set '" + split[1] + "'");
                    break;
                }
                case "update": {
                    List<Action> actions = this.dbm.recommendUpdateActions();
                    if (actions == null || actions.size() == 0) {
                        console.info("No update actions.");
                        break;
                    }
                    console.info("About to execute action(s):\n");
                    for (Action action : actions) {
                        console.info(action.summary());
                    }
                    console.info("");
                    if (this.confirm("Do you want to proceeed with above actions:", new String[]{"yes", "no"}, "yes")) {
                        this.dbm.executeActionsWithLock(actions);
                        break;
                    }
                    console.info("Update cancelled.");
                    break;
                }
                case "apply": {
                    this.dbm.apply(split[1]);
                    break;
                }
                case "reapply": {
                    this.dbm.reapply(split[1]);
                    break;
                }
                case "rollback": {
                    this.dbm.rollback(split[1]);
                    break;
                }
                case "clear": {
                    console.clear();
                    break;
                }
                case "init": {
                    this.dbm.initDB();
                    break;
                }
                case "quit": {
                    if (this.lock != null) {
                        this.dbm.unlock(this.lock);
                    }
                    System.exit(0);
                    break;
                }
                case "lock": {
                    this.lock = this.dbm.lock();
                    console.info("" + this.lock);
                    break;
                }
                case "unlock": {
                    if (this.lock != null) {
                        this.dbm.unlock(this.lock);
                        break;
                    }
                    console.info("Don't hold any lock.");
                    break;
                }
                case "force-unlock": {
                    DBMLock lock = this.dbm.getExistingLock();
                    if (lock != null) {
                        console.info("Releasing " + lock);
                        this.dbm.unlock(lock);
                        break;
                    }
                    console.info("Can't find any lock.");
                    break;
                }
                case "show": {
                    switch (split[1]) {
                        case "disk.versions": {
                            this.dbm.showDiskVersions();
                            break block20;
                        }
                        case "db.versions": {
                            this.dbm.showDBHistory();
                            break block20;
                        }
                        case "status": {
                            this.dbm.showVersionStatus();
                            break block20;
                        }
                        case "recommendations": {
                            this.showRecommendationsShort();
                            break block20;
                        }
                        case "lock": {
                            DBMLock lock = this.dbm.getExistingLock();
                            if (lock != null) {
                                console.info("" + lock);
                                break block20;
                            }
                            console.info("No Lock.");
                            break block20;
                        }
                    }
                    console.warn("Don't know how to show '" + split[1] + "'");
                    break;
                }
                case "?": 
                case "help": {
                    console.println(usage);
                    break;
                }
                case "": {
                    break;
                }
                default: {
                    console.warn("Do not understand '" + split[0] + "'");
                }
            }
        }
        catch (Exception ex) {
            console.error("Error in DBM Processor", ex);
        }
        return this;
    }

    void showRecommendationsShort() throws IOException, SQLException {
        List<Action> actions = this.dbm.recommendUpdateActions();
        if (actions == null || actions.size() == 0) {
            console.info("No Recommendations.");
        } else {
            console.info("Recommend: ");
            for (Action action : actions) {
                console.info("   " + action);
            }
        }
    }

    boolean confirm(String message, String[] options, String positive) throws IOException {
        String x = this.confirm(message, options);
        return x.equals(positive);
    }

    String confirm(String message, String[] options) throws IOException {
        try {
            List<String> lopt = Arrays.asList(options);
            console.setCompleters(Arrays.asList(new StringsCompleter(lopt)));
            String line = console.readLine(message + " " + lopt + "?").trim();
            while (!lopt.contains(line)) {
                console.warn("Please choose from available options");
                line = console.readLine(message + " " + lopt + "?").trim();
            }
            return line;
        }
        catch (Exception ex) {
            console.warn("Error confirming selection.", ex);
            return "";
        }
    }
}

