/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.db.jsql.cli;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import jline.console.completer.Completer;
import jline.console.completer.FileNameCompleter;
import jline.console.completer.StringsCompleter;
import net.jmatrix.db.common.console.SysConsole;
import net.jmatrix.db.common.console.TextConsole;
import net.jmatrix.db.jsql.JSQL;
import net.jmatrix.db.jsql.SQLRunner;
import net.jmatrix.db.jsql.cli.ConnectProcessor;
import net.jmatrix.db.jsql.cli.DBMProcessor;
import net.jmatrix.db.jsql.cli.ExportProcessor;
import net.jmatrix.db.jsql.cli.LineModeProcessor;
import net.jmatrix.db.jsql.cli.PreparedStatementProcessor;
import net.jmatrix.db.jsql.cli.ReconnectProcessor;
import net.jmatrix.db.jsql.cli.SQLProcessor;
import net.jmatrix.db.jsql.cli.commands.Command;
import net.jmatrix.db.jsql.cli.commands.DescribeCommand;
import net.jmatrix.db.jsql.cli.commands.SetCommand;
import net.jmatrix.db.jsql.cli.commands.ShowCommand;

public class CommandProcessor
implements LineModeProcessor {
    static final TextConsole console = SysConsole.getConsole();
    JSQL jsql = null;
    List<Command> commands = null;
    List<Completer> completers = new ArrayList<Completer>();
    String usage = "   connect - leads through prompts to connect to DB.\n   reconnect - reconnect to recent databases.\n   disconnect - disconnects\n   exit: exits the VM.\n\n   [select|insert|update|delete|create|drop] ... : enter single line sql directly. \n   sql: enter multiline sql mode\n   sp: enter prepared statement / stored proc processor.\n   @<sqlfile>: execute a file.  Command line completion of files\n\n   dbm: enter DBM mode.  Schema Management.\n   show \n      db - information about the database\n      tables [spec] - list tables\n      views - list views\n      connection - list views\n   describe <table> - show columns for the table.\n   export [table]: prompts to export data as inserts from a file.\n\n   clear: clear the screen\n";

    public CommandProcessor(JSQL j) {
        this.jsql = j;
        this.commands = new ArrayList<Command>();
        this.commands.add(new ShowCommand(this.jsql));
        this.commands.add(new DescribeCommand(this.jsql));
        this.commands.add(new SetCommand(this.jsql));
        List<String> commands = Arrays.asList("connect", "reconnect", "disconnect", "exit", "quit", "describe", "export", "show", "show db", "show tables", "show views", "show connection", "show procedures", "select", "insert", "update", "delete", "create", "drop", "dbm", "clear", "help", "?");
        StringsCompleter cc = new StringsCompleter(commands);
        CustomCommandCompleter customCompleter = new CustomCommandCompleter(cc);
        this.completers.add(customCompleter);
    }

    @Override
    public String prompt() {
        return "JSQL>";
    }

    @Override
    public Collection<Completer> getCompleters() {
        return this.completers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public LineModeProcessor processLine(String line) {
        String[] split = line.split(" ");
        String command = split[0];
        long start = System.currentTimeMillis();
        try {
            if (line.startsWith("@")) {
                String filename = line.substring(1).trim();
                File file = new File(filename);
                SQLRunner sqlrunner = new SQLRunner(this.jsql, file);
                sqlrunner.run();
                CommandProcessor commandProcessor = this;
                return commandProcessor;
            }
            switch (command) {
                case "sql": {
                    SQLProcessor sqlrunner = new SQLProcessor(this.jsql);
                    return sqlrunner;
                }
                case "help": 
                case "?": {
                    System.out.println(this.usage);
                    return this;
                }
                case "exit": 
                case "quit": {
                    System.exit(0);
                    return this;
                }
                case "connect": {
                    ConnectProcessor sqlrunner = new ConnectProcessor(this.jsql, line);
                    return sqlrunner;
                }
                case "reconnect": {
                    ReconnectProcessor sqlrunner = new ReconnectProcessor(this.jsql);
                    return sqlrunner;
                }
                case "ps": 
                case "sp": {
                    PreparedStatementProcessor sqlrunner = new PreparedStatementProcessor(this.jsql);
                    return sqlrunner;
                }
                case "export": {
                    ExportProcessor sqlrunner = new ExportProcessor(this.jsql, line);
                    return sqlrunner;
                }
                case "dbm": {
                    if (!this.jsql.isConnected()) {
                        console.warn("Not Connected.");
                        return this;
                    }
                    DBMProcessor sqlrunner = new DBMProcessor(this.jsql);
                    return sqlrunner;
                }
                case "disconnect": {
                    this.jsql.disconnect();
                    return this;
                }
                case "select": 
                case "insert": 
                case "update": 
                case "delete": 
                case "drop": 
                case "create": {
                    SQLProcessor sp = new SQLProcessor(this.jsql);
                    sp.execute(line);
                    return this;
                }
                case "getenv": {
                    if (split.length == 2) {
                        System.out.println(split[1] + ":" + System.getenv(split[1]));
                        return this;
                    } else {
                        Map<String, String> env = System.getenv();
                        ArrayList<String> keys = new ArrayList<String>();
                        keys.addAll(env.keySet());
                        Collections.sort(keys);
                        for (String key : keys) {
                            System.out.println(key + ":" + env.get(key));
                        }
                    }
                    return this;
                }
                case "clear": {
                    console.clear();
                    return this;
                }
                case "history": 
                case "": {
                    return this;
                }
                default: {
                    Command c = this.getCommand(command);
                    if (c != null) {
                        c.process(line);
                        return this;
                    } else {
                        console.warn("Do not understand command '" + command + "'");
                    }
                    return this;
                }
            }
        }
        catch (Exception ex) {
            console.error("Error in CommandProcessor.", ex);
            return this;
        }
        finally {
            long et = System.currentTimeMillis() - start;
            if (et > 20L) {
                console.info(command + " took " + et + "ms");
            }
        }
    }

    Command getCommand(String c) {
        for (Command command : this.commands) {
            if (!command.accepts(c)) continue;
            return command;
        }
        return null;
    }

    public static class CustomCommandCompleter
    implements Completer {
        Completer stringCompleter = null;
        Completer fileCompleter = null;

        public CustomCommandCompleter(Completer c) {
            this.stringCompleter = c;
            this.fileCompleter = new FileNameCompleter();
        }

        @Override
        public int complete(String buffer, int pos, List<CharSequence> candidates) {
            if (buffer.startsWith("@")) {
                int index = this.fileCompleter.complete(buffer.substring(1), pos, candidates);
                return index + 1;
            }
            return this.stringCompleter.complete(buffer, pos, candidates);
        }
    }
}

