/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.db.jsql;

import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import net.jmatrix.db.common.ArgParser;
import net.jmatrix.db.common.ConnectionInfo;
import net.jmatrix.db.common.DebugUtils;
import net.jmatrix.db.common.StringUtils;
import net.jmatrix.db.common.console.SysConsole;
import net.jmatrix.db.common.console.TextConsole;
import net.jmatrix.db.jsql.cli.CommandProcessor;
import net.jmatrix.db.jsql.cli.LineModeProcessor;
import net.jmatrix.db.jsql.formatters.PrettyFormatter;
import net.jmatrix.db.jsql.formatters.RSFormatter;
import net.jmatrix.db.jsql.model.RecentConnections;

public class JSQL {
    static final TextConsole console = SysConsole.getConsole();
    public static String JSQL = "jsql";
    ConnectionInfo conInfo = null;
    RSFormatter formatter = new PrettyFormatter(console);
    RecentConnections recentConnections = null;

    JSQL(TextConsole c) {
        if (c != null) {
            this.formatter.set("width", c.getColumns());
            this.formatter.set("lines", c.getRows());
        }
        try {
            this.recentConnections = RecentConnections.load(JSQL);
        }
        catch (Exception ex) {
            console.error("Error loading recent connections", ex);
        }
    }

    public static void main(String[] args) throws Exception {
        ArgParser ap = new ArgParser(args);
        TextConsole console = SysConsole.getConsole();
        if (ap.getBooleanArg("-v")) {
            console.setLevel(TextConsole.Level.DEBUG);
        } else {
            console.setLevel(TextConsole.Level.LOG);
        }
        System.out.println(console);
        JSQL jsql = new JSQL(console);
        if (ap.getBooleanArg("-r")) {
            ConnectionInfo ci = jsql.getRecentConnections().getMostRecent();
            if (ci != null) {
                System.out.println("Reconnecting to " + ci.toString());
                DebugUtils.sleep(10L);
                try {
                    jsql.connect(ci);
                }
                catch (SQLException ex) {
                    console.warn("Cannot connect: " + ci, ex);
                }
            } else {
                System.out.println("-r ignored.  No recent connections.");
            }
        } else if (ap.getBooleanArg("-c")) {
            String connect = ap.getStringArg("-c");
            jsql.connect(connect);
        }
        console.println(net.jmatrix.db.jsql.JSQL.splash());
        jsql.start();
    }

    private static String splash() {
        StringBuilder sb = new StringBuilder();
        String jsqlart = "   .-. .--.  .--. .-.   \n   : :: .--': ,. :: :   \n _ : :`. `. : :: :: :   \n: :; : _`, :: :;_:: :__ \n`.__.'`.__.'`._:_;:___.'";
        sb.append("\n" + jsqlart + "\n\n");
        Properties p = new Properties();
        try {
            URL url = ClassLoader.getSystemResource("build.properties");
            console.debug("Build Properties: " + url);
            p.load(url.openStream());
        }
        catch (Exception ex) {
            console.debug("Error loading build properties.", ex);
        }
        sb.append("  Version: " + p.getProperty("version") + "\n");
        sb.append("    Build: " + p.getProperty("build.time") + "\n");
        return sb.toString();
    }

    public void start() {
        Thread t = new Thread(new SystemInProcessor());
        t.setName("sys.in.proc");
        t.start();
    }

    public boolean isConnected() {
        return this.conInfo != null && this.conInfo.isConnected();
    }

    void connect(String s) throws SQLException {
        console.info("Connecting '" + s + "'");
        ConnectionInfo ci = new ConnectionInfo(s);
        this.connect(ci);
    }

    public void connect(String driver, String url, String user, String pass) throws SQLException {
        ConnectionInfo ci = new ConnectionInfo(driver, url, user, pass);
        this.connect(ci);
    }

    public void connect(ConnectionInfo ci) throws SQLException {
        ci.initDefaultConnection();
        this.conInfo = ci;
        this.formatter.setConnectionInfo(this.conInfo);
        console.println("connected.");
        if (this.recentConnections != null) {
            this.recentConnections.update(this.conInfo);
            try {
                this.recentConnections.save(JSQL);
            }
            catch (Exception ex) {
                console.warn("Could not save recent Connections: " + ex.toString());
            }
        } else {
            console.println("RecentConnections not available.");
        }
        this.connectBanner();
    }

    public void disconnect() {
        try {
            this.conInfo.close();
        }
        catch (Exception ex) {
            console.error("Error disconnecting.", ex);
        }
        this.conInfo = null;
        console.println("disconnected.");
    }

    void connectBanner() {
        StringBuilder banner = new StringBuilder();
        Connection con = this.conInfo.getDefaultConnection();
        Driver driver = this.conInfo.getDriver();
        banner.append(StringUtils.pad(console.getColumns(), '-') + "\n");
        banner.append("    Driver  class: " + this.conInfo.getDriverClass() + "\n");
        banner.append("          version: " + driver.getMajorVersion() + "." + driver.getMinorVersion() + "\n");
        banner.append("\n");
        banner.append("    Connected as " + this.conInfo.getUsername() + " to " + this.conInfo.getUrl() + "\n");
        banner.append("    Flavor: " + (Object)((Object)this.conInfo.getFlavor()) + "\n");
        banner.append("\n");
        try {
            DatabaseMetaData dbmd = con.getMetaData();
            banner.append("    Database Product: " + dbmd.getDatabaseProductName() + "\n");
            banner.append("             Version: " + dbmd.getDatabaseProductVersion() + "\n");
        }
        catch (SQLException ex) {
            banner.append("Error getting DB MetaData: " + ex);
        }
        banner.append(StringUtils.pad(console.getColumns(), '-') + "\n");
        console.println(banner.toString());
    }

    public TextConsole getConsole() {
        return console;
    }

    public Connection getConnection() {
        return this.conInfo.getDefaultConnection();
    }

    public ConnectionInfo getConnectionInfo() {
        return this.conInfo;
    }

    public RSFormatter getFormatter() {
        return this.formatter;
    }

    public void setFormatter(RSFormatter f) {
        this.formatter = f;
    }

    public RecentConnections getRecentConnections() {
        return this.recentConnections;
    }

    class SystemInProcessor
    implements Runnable {
        CommandProcessor commandProcessor = null;
        LineModeProcessor currentProcessor = null;

        public SystemInProcessor() {
            this.commandProcessor = new CommandProcessor(JSQL.this);
            this.currentProcessor = this.commandProcessor;
        }

        @Override
        public void run() {
            try {
                console.setCompleters(this.currentProcessor.getCompleters());
                String line = console.readLine(this.currentProcessor.prompt());
                while (line != null) {
                    this.currentProcessor = this.currentProcessor.processLine(line);
                    if (this.currentProcessor == null) {
                        this.currentProcessor = this.commandProcessor;
                    }
                    console.setCompleters(this.currentProcessor.getCompleters());
                    line = console.readLine(this.currentProcessor.prompt());
                }
            }
            catch (Exception ex) {
                console.error("Error in processor loop", ex);
            }
        }
    }
}

