/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.db.common.console;

import net.jmatrix.db.common.DebugUtils;
import net.jmatrix.db.common.StreamUtil;
import net.jmatrix.db.common.StringUtils;
import net.jmatrix.db.common.console.AbstractConsole;
import net.jmatrix.db.common.console.TextConsole;

public class LinuxConsole
extends AbstractConsole
implements TextConsole {
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_BLACK = "\u001b[30m";
    public static final String ANSI_RED = "\u001b[31m";
    public static final String ANSI_GREEN = "\u001b[32m";
    public static final String ANSI_YELLOW = "\u001b[33m";
    public static final String ANSI_BLUE = "\u001b[34m";
    public static final String ANSI_PURPLE = "\u001b[35m";
    public static final String ANSI_CYAN = "\u001b[36m";
    public static final String ANSI_WHITE = "\u001b[37m";

    public String toString() {
        return "LinuxConsole [" + this.getRows() + "x" + this.getColumns() + "]";
    }

    @Override
    public int getRows() {
        try {
            ProcessBuilder pb = new ProcessBuilder("/bin/bash", "-c", "tput lines 2>/dev/tty");
            Process p = pb.start();
            int exit = p.waitFor();
            String s = StreamUtil.readToString(p.getInputStream());
            return Integer.parseInt(s.trim());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    @Override
    public int getColumns() {
        try {
            ProcessBuilder pb = new ProcessBuilder("/bin/bash", "-c", "tput cols 2>/dev/tty");
            Process p = pb.start();
            int exit = p.waitFor();
            String s = StreamUtil.readToString(p.getInputStream());
            return Integer.parseInt(s.trim());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    @Override
    public void clear() {
        int rows = this.getRows();
        if (rows <= 0) {
            rows = 30;
        }
        System.out.println(StringUtils.pad(rows, '\n'));
    }

    private static final String color(String key, String s) {
        return key + s + ANSI_RESET;
    }

    @Override
    public void error(String s, Throwable t) {
        System.out.println(LinuxConsole.color(ANSI_RED, s));
        if (t != null) {
            System.out.println(LinuxConsole.color(ANSI_RED, DebugUtils.stackString(t)));
        }
    }

    @Override
    public void warn(String s, Throwable t) {
        System.out.println(LinuxConsole.color(ANSI_YELLOW, s));
        if (t != null) {
            System.out.println(LinuxConsole.color(ANSI_YELLOW, DebugUtils.stackString(t)));
        }
    }
}

