/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.db.common;

import java.io.File;
import java.io.IOException;
import net.jmatrix.db.common.StreamUtil;

public class DotConfig {
    String app = null;
    File dir = null;

    public DotConfig(String app) {
        this.app = app;
        this.init();
    }

    private void init() {
        this.dir = new File(System.getProperty("user.home") + "/.config/" + this.app);
        if (!this.dir.exists()) {
            this.dir.mkdirs();
        }
        if (this.dir.exists()) {
            if (!this.dir.canRead()) {
                throw new RuntimeException("Cannot read config dir at " + this.dir.getAbsolutePath());
            }
        } else {
            throw new RuntimeException("Config dir does not exist at " + this.dir.getAbsolutePath());
        }
    }

    public void write(String filename, String s) throws IOException {
        File f = new File(this.dir, filename);
        StreamUtil.write(s, f);
    }

    public String read(String filename) throws IOException {
        File f = new File(this.dir, filename);
        if (!f.exists()) {
            return null;
        }
        return StreamUtil.readToString(f);
    }
}

