/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.db.schema.action;

import java.io.File;
import java.util.List;
import net.jmatrix.db.common.ClassLogFactory;
import net.jmatrix.db.schema.DBM;
import net.jmatrix.db.schema.DBMException;
import net.jmatrix.db.schema.DiskVersion;
import net.jmatrix.db.schema.action.AbstractAction;
import net.jmatrix.db.schema.action.ApplyAction;
import net.jmatrix.db.schema.action.RollbackAction;
import org.slf4j.Logger;

public class ReapplyAction
extends AbstractAction {
    private static Logger log = ClassLogFactory.getLog();
    DiskVersion version = null;
    RollbackAction rollback = null;
    ApplyAction apply = null;

    public ReapplyAction(DBM d, DiskVersion dv) {
        super(d);
        this.version = dv;
        this.rollback = new RollbackAction(d, dv);
        this.apply = new ApplyAction(d, dv);
    }

    public String toString() {
        return "Reapply(" + this.version.getVersion() + ")";
    }

    @Override
    public String summary() {
        StringBuilder sb = new StringBuilder();
        sb.append("Reapply: DiskVersion " + this.version.getVersion() + " at " + this.version.getPath() + "\n");
        List<File> files = null;
        files = this.version.getRollbackFiles();
        if (files != null) {
            sb.append("        Rollback:\n");
            files = this.version.getRollbackFiles();
            for (File f : files) {
                sb.append("          File: " + f.getName() + "\n");
            }
        }
        if ((files = this.version.getApplyFiles()) != null) {
            sb.append("        Apply:\n");
            for (File f : files) {
                sb.append("          File: " + f.getName() + "\n");
            }
        }
        return sb.toString();
    }

    @Override
    public boolean execute() throws DBMException {
        log.info(">>>>>>>>>>>>> Reapply " + this.version);
        if (this.rollback.execute()) {
            return this.apply.execute();
        }
        return false;
    }
}

