/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.db.common.console;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import jline.Terminal;
import jline.console.ConsoleReader;
import jline.console.UserInterruptException;
import jline.console.completer.Completer;
import net.jmatrix.db.common.DebugUtils;
import net.jmatrix.db.common.console.AbstractConsole;
import net.jmatrix.db.common.console.TextConsole;

public class JLineConsole
extends AbstractConsole {
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_BLACK = "\u001b[30m";
    public static final String ANSI_RED = "\u001b[31m";
    public static final String ANSI_GREEN = "\u001b[32m";
    public static final String ANSI_YELLOW = "\u001b[33m";
    public static final String ANSI_BLUE = "\u001b[34m";
    public static final String ANSI_PURPLE = "\u001b[35m";
    public static final String ANSI_CYAN = "\u001b[36m";
    public static final String ANSI_WHITE = "\u001b[37m";
    ConsoleReader reader = new ConsoleReader();
    PrintWriter out = null;
    Terminal terminal = null;

    public JLineConsole() throws IOException {
        this.reader.setHandleUserInterrupt(true);
        this.out = new PrintWriter(this.reader.getOutput());
        this.terminal = this.reader.getTerminal();
    }

    public String toString() {
        return "JLineConsole(" + this.getRows() + "x" + this.getColumns() + ", " + (Object)((Object)this.level) + ")";
    }

    @Override
    public void setCompleters(Collection<Completer> completers) {
        Collection old = this.reader.getCompleters();
        if (old != null) {
            for (Completer c : old) {
                this.reader.removeCompleter(c);
            }
        }
        if (completers != null) {
            for (Completer c : completers) {
                this.reader.addCompleter(c);
            }
        }
    }

    @Override
    public int getRows() {
        return this.terminal.getHeight();
    }

    @Override
    public int getColumns() {
        return this.terminal.getWidth();
    }

    @Override
    public void clear() {
        try {
            this.reader.clearScreen();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public ConsoleReader getReader() {
        return this.reader;
    }

    @Override
    public void print(String s) {
        this.out.print(s);
        this.out.flush();
    }

    @Override
    public void println(String s) {
        this.out.println(s);
        this.out.flush();
    }

    private static final String color(String key, String s) {
        return key + s + ANSI_RESET;
    }

    @Override
    public String readLine(String prompt) throws IOException {
        try {
            return this.reader.readLine(prompt);
        }
        catch (UserInterruptException ex) {
            String partial = ex.getPartialLine();
            if (partial.length() == 0) {
                this.println("System exit via CTRL-C");
                System.exit(1);
                return null;
            }
            return "";
        }
    }

    @Override
    public void error(String s, Throwable t) {
        this.println(JLineConsole.color(ANSI_RED, s));
        if (t != null) {
            this.println(JLineConsole.color(ANSI_RED, DebugUtils.stackString(t)));
        }
    }

    @Override
    public void warn(String s, Throwable t) {
        this.println(JLineConsole.color(ANSI_YELLOW, s));
        if (t != null) {
            if (this.level.ilevel >= TextConsole.Level.DEBUG.ilevel) {
                this.println(JLineConsole.color(ANSI_YELLOW, DebugUtils.stackString(t)));
            } else {
                this.println(JLineConsole.color(ANSI_YELLOW, t.toString()));
                this.println("Stack trace omitted.  'set log debug' to see full stack traces.");
            }
        }
    }
}

