/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.db.common.console;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import jline.console.completer.Completer;
import net.jmatrix.db.common.DebugUtils;
import net.jmatrix.db.common.console.TextConsole;

public abstract class AbstractConsole
implements TextConsole {
    TextConsole.Level level = TextConsole.Level.LOG;
    BufferedReader br = new BufferedReader(new InputStreamReader(System.in));

    protected AbstractConsole() {
    }

    @Override
    public void setCompleters(Collection<Completer> completers) {
    }

    @Override
    public void setLevel(TextConsole.Level l) {
        this.level = l;
    }

    @Override
    public TextConsole.Level getLevel() {
        return this.level;
    }

    @Override
    public String readLine(String prompt) throws IOException {
        this.print(prompt);
        return this.br.readLine();
    }

    @Override
    public void info(String s) {
        this.info(s, null);
    }

    @Override
    public void info(String s, Throwable t) {
        this.println(s);
        if (t != null) {
            this.println(DebugUtils.stackString(t));
        }
    }

    @Override
    public void debug(String s) {
        this.debug(s, null);
    }

    @Override
    public void debug(String s, Throwable t) {
        if (this.level.getILevel() >= TextConsole.Level.DEBUG.getILevel()) {
            this.info(s, t);
        }
    }

    @Override
    public void warn(String s) {
        this.warn(s, null);
    }

    @Override
    public void warn(String s, Throwable t) {
        this.info(s, t);
    }

    @Override
    public void error(String s) {
        this.error(s, null);
    }

    @Override
    public void error(String s, Throwable t) {
        this.info(s, t);
    }

    @Override
    public void print(String s) {
        System.out.print(s);
    }

    @Override
    public void println(String s) {
        System.out.println(s);
    }
}

