/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.db.common;

import java.lang.reflect.Field;
import java.sql.Types;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jmatrix.db.common.console.SysConsole;
import net.jmatrix.db.common.console.TextConsole;

public class SQLUtil {
    static TextConsole console;
    static Map<Integer, String> typeNameMap;

    public static String stripSQLComments(String sql) {
        console.debug("SQL before comment removal, length is " + sql.length());
        String multiLineRegex = "/\\*(.)*?\\*/";
        Pattern multiLinePattern = Pattern.compile(multiLineRegex, 32);
        Matcher matcher = multiLinePattern.matcher(sql);
        sql = matcher.replaceAll("");
        console.debug("SQL after multiline comment removal, length is " + sql.length());
        String singleLineRegex = "^(\\s)*\\-\\-.*?$";
        Pattern singleLinePattern = Pattern.compile(singleLineRegex, 8);
        matcher = singleLinePattern.matcher(sql);
        sql = matcher.replaceAll("");
        console.debug("SQL after single line comment removal, length is " + sql.length());
        return sql;
    }

    public static List<String> splitSQL(String sql, String delimiter) {
        ArrayList<String> statements = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(sql, delimiter, false);
        while (st.hasMoreTokens()) {
            String statement = st.nextToken().trim();
            if (statement.length() <= 1) continue;
            statements.add(statement);
        }
        return statements;
    }

    public static String jdbcTypeString(int i) {
        String name = typeNameMap.get(i);
        if (name == null) {
            return "UNKNOWN";
        }
        return name;
    }

    public static String escape(String string) {
        return string.replace("'", "''");
    }

    static {
        Field[] fields;
        console = SysConsole.getConsole();
        typeNameMap = new HashMap<Integer, String>();
        Class<Types> c = Types.class;
        for (Field field : fields = c.getFields()) {
            try {
                Object val = field.get(null);
                if (!(val instanceof Number)) continue;
                typeNameMap.put(((Number)val).intValue(), field.getName());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }
}

