/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.db.common;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.jmatrix.db.common.ClassLogFactory;
import org.slf4j.Logger;

public final class DBUtils {
    static Logger log = ClassLogFactory.getLog();

    public static final void close(Connection con, Statement state, ResultSet rs) {
        DBUtils.close(rs);
        DBUtils.close(state);
        DBUtils.close(con);
    }

    public static final void close(Statement state) {
        if (state != null) {
            try {
                state.close();
            }
            catch (Exception ex) {
                log.error("Error closing statement: ", (Throwable)ex);
            }
        }
    }

    public static final void close(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception ex) {
                log.error("Error closing ResultSet: ", (Throwable)ex);
            }
        }
    }

    public static final void close(Connection con) {
        if (con != null) {
            try {
                if (!con.isClosed()) {
                    con.close();
                }
            }
            catch (Exception ex) {
                log.error("Error closing connection: ", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int intFunction(Statement state, String sql) throws SQLException {
        int result = 0;
        ResultSet rs = null;
        try {
            log.trace("intFunction(sql): " + sql);
            rs = state.executeQuery(sql);
            if (rs.next()) {
                result = rs.getInt(1);
            }
        }
        catch (Throwable throwable) {
            DBUtils.close(rs);
            throw throwable;
        }
        DBUtils.close(rs);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date dateFunction(Statement state, String sql) throws SQLException {
        Timestamp result = null;
        ResultSet rs = null;
        try {
            log.trace("dateFunction(sql): " + sql);
            rs = state.executeQuery(sql);
            if (rs.next()) {
                result = rs.getTimestamp(1);
            }
        }
        catch (Throwable throwable) {
            DBUtils.close(rs);
            throw throwable;
        }
        DBUtils.close(rs);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> stringListFunction(Statement state, String sql) throws SQLException {
        ArrayList<String> list = new ArrayList<String>();
        ResultSet rs = null;
        try {
            log.trace("stringListFunction(sql): " + sql);
            rs = state.executeQuery(sql);
            while (rs.next()) {
                list.add(rs.getString(1));
            }
        }
        catch (Throwable throwable) {
            DBUtils.close(rs);
            throw throwable;
        }
        DBUtils.close(rs);
        return list;
    }

    public static final Connection getConnection(String driver, String url, String user, String pass) throws SQLException {
        try {
            log.debug("Connecting to " + url + " as " + user);
            Class.forName(driver);
            Connection con = DriverManager.getConnection(url, user, pass);
            return con;
        }
        catch (Exception ex) {
            throw new SQLException("Error getting connection...", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeUpdate(Connection con, String sql) throws SQLException {
        Statement state = null;
        try {
            state = con.createStatement();
            state.execute(sql);
            int n = state.getUpdateCount();
            return n;
        }
        finally {
            DBUtils.close(state);
        }
    }

    public static final void log(String s) {
        System.out.println(s);
    }
}

