/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.db.common;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import net.jmatrix.db.common.DBUtils;
import net.jmatrix.db.drivers.DriverMap;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class ConnectionInfo
implements Comparable<ConnectionInfo> {
    String url;
    String driverClass;
    String username;
    String passwordB64;
    long lastConnectTime = -1L;
    static final String SCHEMA = "jsql.schema";
    static final String CATALOG = "jsql.catalog";
    Map<String, String> properties;
    Connection connection = null;
    Driver driver = null;
    Flavor flavor = Flavor.GENERIC;
    BASE64Encoder b64encoder = new BASE64Encoder();
    BASE64Decoder b64decoder = new BASE64Decoder();
    static String cformat = "user/pass@jdbc.url";

    public ConnectionInfo() {
    }

    public ConnectionInfo(String d, String u, String un, String pw) {
        this.driverClass = d;
        this.url = u;
        this.username = un;
        this.setPassword(pw);
        this.flavor();
    }

    public ConnectionInfo(String s) throws SQLException {
        int at = s.indexOf("@");
        if (at == -1) {
            throw new SQLException("Invalid Connect format. missing @. use: " + cformat);
        }
        String upw = s.substring(0, at);
        this.url = s.substring(at + 1);
        this.driverClass = DriverMap.findDriver(this.url);
        if (this.driverClass == null) {
            throw new SQLException("Cannot find driver class for url '" + this.url + "'.  Connect with explicit driver.");
        }
        String[] split = upw.split("\\/");
        if (split.length != 2) {
            throw new SQLException("Invalid Connect format.  username password has no '/'. use: " + cformat);
        }
        this.username = split[0];
        String pass = split[1];
        this.setPassword(pass);
        this.flavor();
    }

    public void close() {
        if (this.connection != null) {
            DBUtils.close(this.connection);
        }
    }

    @JsonIgnore
    public void setSchema(String schema) {
        this.setProperty(SCHEMA, schema);
        boolean error = false;
        try {
            this.connection.setSchema(schema);
        }
        catch (Error er) {
            error = true;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    @JsonIgnore
    public String getSchema() {
        String schema = null;
        boolean error = false;
        try {
            schema = this.connection.getSchema();
        }
        catch (Error er) {
            error = true;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        if (!error) {
            return schema;
        }
        schema = this.getProperty(SCHEMA);
        if (schema != null) {
            return schema;
        }
        if (this.flavor == Flavor.ORACLE) {
            return this.username;
        }
        return null;
    }

    @JsonIgnore
    public void setCatalog(String catalog) {
        this.setProperty(CATALOG, catalog);
    }

    @JsonIgnore
    public String getCatalog() {
        return this.getProperty(CATALOG);
    }

    @Override
    public int compareTo(ConnectionInfo o) {
        ConnectionInfo ci = o;
        return Long.compare(ci.lastConnectTime, this.lastConnectTime);
    }

    public int hashCode() {
        return (this.driver + this.url + this.username).hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof ConnectionInfo) {
            ConnectionInfo ci = (ConnectionInfo)o;
            return ConnectionInfo.equals(ci.driverClass, this.driverClass) && ConnectionInfo.equals(ci.url, this.url) && ConnectionInfo.equals(ci.username, this.username);
        }
        return false;
    }

    public String toString() {
        return this.username + " on " + this.url;
    }

    private static final boolean equals(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 != null && s2 != null) {
            return s1.equals(s2);
        }
        return false;
    }

    private void flavor() {
        if (this.url != null) {
            String lurl = this.url.toLowerCase();
            if (lurl.contains("oracle")) {
                this.flavor = Flavor.ORACLE;
            } else if (lurl.contains("sqlserver")) {
                this.flavor = Flavor.SQL_SERVER;
            } else if (lurl.contains("mysql")) {
                this.flavor = Flavor.MYSQL;
            }
        }
    }

    @JsonIgnore
    public boolean isConnected() {
        return this.connection != null;
    }

    public Connection initDefaultConnection() throws SQLException {
        Connection con = this.connect();
        this.setDefaultConnection(con);
        return con;
    }

    public Connection connect() throws SQLException {
        try {
            Class.forName(this.driverClass);
        }
        catch (Exception ex) {
            throw new SQLException("Cannot load driver '" + this.driverClass + "': " + ex);
        }
        try {
            this.driver = DriverManager.getDriver(this.url);
        }
        catch (Exception ex) {
            throw new SQLException("Error getting driver for url '" + this.url + "' " + ex);
        }
        if (this.driver == null) {
            throw new SQLException("No driver accepts url '" + this.url + "'");
        }
        try {
            Connection con = DriverManager.getConnection(this.url, this.username, this.getPassword());
            return con;
        }
        catch (Exception ex) {
            throw new SQLException("Cannot connect: " + ex);
        }
    }

    public void setProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, value);
    }

    public String getProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(key);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
        this.flavor();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @JsonIgnore
    public String getPassword() {
        if (this.passwordB64 == null) {
            return null;
        }
        try {
            return new String(this.b64decoder.decodeBuffer(this.passwordB64), "UTF-8");
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to decode password.");
        }
    }

    @JsonIgnore
    public void setPassword(String password) {
        if (password == null) {
            this.passwordB64 = null;
        }
        this.passwordB64 = this.b64encoder.encode(password.getBytes());
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    @JsonIgnore
    public Connection getDefaultConnection() {
        return this.connection;
    }

    @JsonIgnore
    public void setDefaultConnection(Connection connection) {
        this.lastConnectTime = System.currentTimeMillis();
        this.connection = connection;
    }

    @JsonIgnore
    public Driver getDriver() {
        return this.driver;
    }

    @JsonIgnore
    public void setDriver(Driver driver) {
        this.driver = driver;
    }

    @JsonIgnore
    public Flavor getFlavor() {
        return this.flavor;
    }

    @JsonIgnore
    public void setFlavor(Flavor flavor) {
        this.flavor = flavor;
    }

    public String getPasswordB64() {
        return this.passwordB64;
    }

    public void setPasswordB64(String passwordB64) {
        this.passwordB64 = passwordB64;
    }

    public long getLastConnectTime() {
        return this.lastConnectTime;
    }

    public void setLastConnectTime(long lastConnectTime) {
        this.lastConnectTime = lastConnectTime;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public static enum Flavor {
        ORACLE,
        SQL_SERVER,
        MYSQL,
        HSQL,
        GENERIC;

    }
}

