package net.jmatrix.db.schema;

import java.io.File;

/**
 * Represents a single executable sql statement.
 */
public class SQLStatement {
   DiskVersion diskVersion=null;
   String sql;
   File file;
   
   public SQLStatement(DiskVersion dv, String s, File f) {
      sql=s;
      file=f;
      diskVersion=dv;
   }
   
   public String getFileString() {
      if (file == null)
         return "null";
      return file.getAbsolutePath();
   }

   public String getSql() {
      return sql;
   }

   public File getFile() {
      return file;
   }

   public DiskVersion getDiskVersion() {
      return diskVersion;
   }
}
