/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.db.schema.data.v1;

import java.net.InetAddress;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.jmatrix.db.common.DBUtils;
import net.jmatrix.db.common.Version;
import net.jmatrix.db.common.console.SysConsole;
import net.jmatrix.db.common.console.TextConsole;
import net.jmatrix.db.schema.DBVersion;
import net.jmatrix.db.schema.data.v1.GenericSchemaHasher;

public class DBMData {
    static TextConsole console = SysConsole.getConsole();
    static String DBM_LOG = "DBM_LOG";
    static String DBM_LOG_DDL = "CREATE TABLE DBM_LOG( \n  ID VARCHAR(50) NOT NULL,\n  TSTAMP TIMESTAMP NOT NULL,\n  FILEPATH VARCHAR(500),\n  HOSTNAME VARCHAR(500),\n  USERNAME VARCHAR(500),\n  STATUS VARCHAR(10),\n  NUM_ROWS INTEGER,\n  SQL VARCHAR(4000),\n  ERROR VARCHAR(4000),\nPRIMARY KEY (ID))";
    static String DROP_LOG = "DROP TABLE DBM_LOG";
    static String DBM_VERSIONS = "DBM_VERSIONS";
    static String DBM_VERSIONS_DDL = "CREATE TABLE DBM_VERSIONS(\n  ID VARCHAR(50) NOT NULL,\n  TSTAMP TIMESTAMP NOT NULL,\n  FILEPATH VARCHAR(500),\n   ACTION VARCHAR(20), \n  HOSTNAME VARCHAR(500),\n   USERNAME VARCHAR(500),\n  VERSION VARCHAR(100) NOT NULL,\n  HASH VARCHAR(200),\nPRIMARY KEY(ID))";
    static String DROP_VERSIONS = "DROP TABLE DBM_VERSIONS";
    Connection con = null;

    public DBMData(Connection c) throws SQLException {
        this.con = c;
    }

    public void drop() throws SQLException {
        console.warn("Dropping " + DBM_LOG);
        try {
            DBUtils.executeUpdate(this.con, DROP_LOG);
        }
        catch (Exception ex) {
            // empty catch block
        }
        console.warn("Dropping " + DBM_VERSIONS);
        try {
            DBUtils.executeUpdate(this.con, DROP_VERSIONS);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void init() throws SQLException {
        if (!this.tableExists(DBM_LOG)) {
            console.warn("Creating table " + DBM_LOG + "\n" + DBM_LOG_DDL);
            DBUtils.executeUpdate(this.con, DBM_LOG_DDL);
        }
        if (!this.tableExists(DBM_VERSIONS)) {
            console.warn("Creating table " + DBM_VERSIONS + "\n" + DBM_VERSIONS_DDL);
            DBUtils.executeUpdate(this.con, DBM_VERSIONS_DDL);
            this.setVersion("0", "INITIAL", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean tableExists(String tablename) throws SQLException {
        ResultSet rs;
        block2: {
            boolean bl;
            DatabaseMetaData dbmd = null;
            rs = null;
            console.debug("Looking for table " + tablename);
            try {
                dbmd = this.con.getMetaData();
                rs = dbmd.getTables(null, null, tablename, new String[]{"TABLE"});
                if (!rs.next()) break block2;
                String table = rs.getString("TABLE_NAME");
                console.debug("Found table: " + table);
                bl = true;
            }
            catch (Throwable throwable) {
                DBUtils.close(rs);
                throw throwable;
            }
            DBUtils.close(rs);
            return bl;
        }
        DBUtils.close(rs);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logStatement(String path, String statement, boolean success, int rows, String err) throws SQLException {
        String sql = "insert into " + DBM_LOG + " values(?, ?, ?, ?, ?, ?, ?, ?, ?)";
        console.info("Log sql: " + sql);
        PreparedStatement state = null;
        try {
            state = this.con.prepareStatement(sql);
            state.setString(1, UUID.randomUUID().toString());
            state.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
            state.setString(3, path);
            state.setString(4, DBMData.getHost());
            state.setString(5, DBMData.getUser());
            state.setString(6, success ? "T" : "F");
            state.setInt(7, rows);
            state.setString(8, statement);
            state.setString(9, err);
            state.execute();
        }
        catch (Throwable throwable) {
            DBUtils.close(state);
            throw throwable;
        }
        DBUtils.close(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVersion(String version, String action, String path) throws SQLException {
        String sql = "insert into " + DBM_VERSIONS + " values(?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement state = null;
        try {
            state = this.con.prepareStatement(sql);
            state.setString(1, UUID.randomUUID().toString());
            state.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
            state.setString(3, path);
            state.setString(4, action);
            state.setString(5, DBMData.getHost());
            state.setString(6, DBMData.getUser());
            state.setString(7, version);
            state.setString(8, this.schemaHash());
            state.execute();
        }
        catch (Throwable throwable) {
            DBUtils.close(state);
            throw throwable;
        }
        DBUtils.close(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurrentVersion() throws SQLException {
        ResultSet rs;
        Statement state;
        block3: {
            String string;
            String sql = "select version from " + DBM_VERSIONS + " order by tstamp desc";
            console.debug("Getting current version with \n   " + sql);
            state = null;
            rs = null;
            try {
                state = this.con.createStatement();
                rs = state.executeQuery(sql);
                if (!rs.next()) break block3;
                string = rs.getString(1);
            }
            catch (Throwable throwable) {
                DBUtils.close(null, state, rs);
                throw throwable;
            }
            DBUtils.close(null, state, rs);
            return string;
        }
        String string = null;
        DBUtils.close(null, state, rs);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPreviousVersion() throws SQLException {
        ResultSet rs;
        Statement state;
        block3: {
            String string;
            String sql = "select version from " + DBM_VERSIONS + " order by tstamp desc";
            console.debug("Getting current version with \n   " + sql);
            state = null;
            rs = null;
            try {
                state = this.con.createStatement();
                rs = state.executeQuery(sql);
                rs.next();
                if (!rs.next()) break block3;
                string = rs.getString(1);
            }
            catch (Throwable throwable) {
                DBUtils.close(null, state, rs);
                throw throwable;
            }
            DBUtils.close(null, state, rs);
            return string;
        }
        String string = null;
        DBUtils.close(null, state, rs);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DBVersion> getDBVersions() throws SQLException {
        ArrayList<DBVersion> arrayList;
        String sql = "select * from " + DBM_VERSIONS + " order by tstamp desc";
        console.debug("Getting db versions with \n   " + sql);
        Statement state = null;
        ResultSet rs = null;
        try {
            state = this.con.createStatement();
            rs = state.executeQuery(sql);
            ArrayList<DBVersion> versions = new ArrayList<DBVersion>();
            while (rs.next()) {
                versions.add(DBMData.buildDBVersion(rs));
            }
            arrayList = versions;
        }
        catch (Throwable throwable) {
            DBUtils.close(null, state, rs);
            throw throwable;
        }
        DBUtils.close(null, state, rs);
        return arrayList;
    }

    private static final DBVersion buildDBVersion(ResultSet rs) throws SQLException {
        DBVersion dbv = new DBVersion();
        dbv.setVersion(new Version(rs.getString("version")));
        dbv.setAction(rs.getString("action"));
        dbv.setApplyDate(rs.getTimestamp("tstamp"));
        dbv.setHostname(rs.getString("hostname"));
        return dbv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String schemaHash() {
        GenericSchemaHasher hasher = new GenericSchemaHasher(this.con);
        try {
            String hash;
            String string = hash = hasher.calculateSchemaHash();
            return string;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String string = "error";
            return string;
        }
    }

    static String getHost() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (Exception ex) {
            return "unknown";
        }
    }

    static String getUser() {
        return System.getProperty("user.name");
    }
}

