/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.jproperties.util;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.jmatrix.jproperties.JPRuntimeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import sun.misc.BASE64Encoder;

public class URLUtil {
    public static Log log = LogFactory.getLog(URLUtil.class);
    public static boolean ALLOW_UNTRUSTED_SSL = true;

    public static final String convertClasspathURL(String surl) {
        String lcurl = surl.toLowerCase();
        if (lcurl.startsWith("classpath:/")) {
            log.debug((Object)("Found classpath URL: " + surl));
            String resourcepath = surl.substring("classpath:/".length());
            log.debug((Object)("Resource path: " + resourcepath));
            URL sysurl = ClassLoader.getSystemResource(resourcepath);
            log.debug((Object)("System URL from Classloader.getSystemResource(): " + sysurl));
            if (sysurl == null) {
                sysurl = URLUtil.class.getClassLoader().getResource(resourcepath);
                log.debug((Object)("System URL from URLUtil.class.getClassLoader().getResource(): " + sysurl));
            }
            if (sysurl == null) {
                throw new JPRuntimeException("Cannot find resource '" + resourcepath + "' in classpath for URL " + surl);
            }
            log.debug((Object)(surl + " -> " + sysurl.toExternalForm()));
            surl = sysurl.toExternalForm();
        }
        return surl;
    }

    public static long lastMod(URL url) throws IOException {
        URLConnection con = URLUtil.getConnection(url);
        long lastmod = con.getLastModified();
        log.debug((Object)("Returning last modified: " + lastmod));
        return lastmod;
    }

    public static URLConnection getConnection(URL url) throws IOException {
        String userInfo;
        URLConnection con = url.openConnection();
        log.trace((Object)("URL: \n" + URLUtil.debugURL(url)));
        if (con instanceof HttpsURLConnection && ALLOW_UNTRUSTED_SSL) {
            HttpsURLConnection httpsCon = (HttpsURLConnection)con;
            log.warn((Object)("Creating un-trusted SSL connection to: " + url.toExternalForm()));
            try {
                SSLContext sc = SSLContext.getInstance("SSL");
                TrustManager[] tmchain = new TrustManager[]{new TrustAll()};
                sc.init(null, tmchain, new SecureRandom());
                httpsCon.setSSLSocketFactory(sc.getSocketFactory());
                httpsCon.setHostnameVerifier(new HostVerifyAll());
            }
            catch (GeneralSecurityException ex) {
                throw new IOException("Error trying to establish SSL Connection", ex);
            }
            con = httpsCon;
        }
        if ((userInfo = url.getUserInfo()) != null) {
            log.info((Object)("Adding Auth Info: " + userInfo));
            String encodedAuth = new BASE64Encoder().encode(userInfo.getBytes());
            con.setRequestProperty("Authorization", "Basic " + encodedAuth);
        }
        return con;
    }

    public static final String debugURL(URL url) {
        StringBuilder sb = new StringBuilder();
        sb.append("  URL: " + url.toExternalForm() + "\n");
        sb.append("      Authority: " + url.getAuthority() + "\n");
        sb.append("    DefaultPort: " + url.getDefaultPort() + "\n");
        sb.append("           File: " + url.getFile() + "\n");
        sb.append("           Host: " + url.getHost() + "\n");
        sb.append("           Path: " + url.getPath() + "\n");
        sb.append("           Port: " + url.getPort() + "\n");
        sb.append("       Protocol: " + url.getProtocol() + "\n");
        sb.append("          Query: " + url.getQuery() + "\n");
        sb.append("            Ref: " + url.getRef() + "\n");
        sb.append("       UserInfo: " + url.getUserInfo() + "\n");
        return sb.toString();
    }

    private static class HostVerifyAll
    implements HostnameVerifier {
        private HostVerifyAll() {
        }

        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    private static class TrustAll
    implements X509TrustManager {
        private TrustAll() {
        }

        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

