/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.jproperties.cli;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import net.jmatrix.jproperties.JProperties;
import net.jmatrix.jproperties.WrappedProperties;
import net.jmatrix.jproperties.parser.Parser;
import net.jmatrix.jproperties.util.ArgParser;
import net.jmatrix.jproperties.util.JDK14LogConfig;
import net.jmatrix.jproperties.util.URLUtil;

public class JPropertiesCLI {
    static boolean debug = false;
    static final String usage = "JPropertiesCLI [options] properties.file\n \n  With no options, just a properties file, the CLI will parse the properties \n  file as json properties, including processing incldues, and print the \n  result to System.out with all substitutions.\n\nOptions: \n \n   -s <properties>\n      Split.  Splits a (java.util.)Properties file into a json tree structure\n      based on a delimeter.  \n\n   -f <jproperties>\n      Flatten.  Takes a jproperties file and flattens it to a \n      java.util.Properties format\n      using the specified delimeter, or \".\" if none specified.\n\n      Note - flattening delimiter cannot be a component of any key \n      within the JProperties tree.\n      for instance, if you have a key foo.bar in JProperties, you \n      cannot use '.' as the delimeter for flattening (or wrapping\n      see WrappedProperties.java)\n\n   -d <delimeters>\n      Defaults to \".\" - can substitute any other characters\n \n   -o <file>\n      output file, if not, system.out";

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println(usage);
            System.exit(1);
        }
        ArgParser ap = new ArgParser(args);
        String delim = ap.getStringArg("-d");
        String outfilename = ap.getStringArg("-o");
        debug = ap.getBooleanArg("-v");
        if (debug) {
            JDK14LogConfig.startup();
        }
        String inputurlstring = ap.getLastArg();
        URL inputUrl = null;
        if (inputurlstring.startsWith("classpath:") || inputurlstring.startsWith("http:") || inputurlstring.startsWith("jar:")) {
            inputUrl = new URL(URLUtil.convertClasspathURL(inputurlstring));
        } else {
            File infile = new File(inputurlstring);
            inputUrl = infile.toURL();
        }
        if (debug) {
            System.err.println("URL:  " + inputUrl);
        }
        InputStream is = null;
        try {
            is = inputUrl.openStream();
            if (is == null) {
                System.err.println("Cannot read from input URL: " + inputUrl);
                System.exit(2);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println("Cannot read from input URL: " + inputUrl);
            System.exit(3);
        }
        if (ap.getBooleanArg("-f")) {
            JProperties jp = Parser.parse(inputUrl);
            Character d = null;
            if (delim != null) {
                d = Character.valueOf(delim.toCharArray()[0]);
            }
            WrappedProperties wp = new WrappedProperties(jp, d);
            Enumeration keys = wp.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement().toString();
                String value = wp.getProperty(key);
                System.err.println(key + "=" + value);
            }
        } else if (ap.getBooleanArg("-s")) {
            Properties jup = new Properties();
            JProperties jp = new JProperties();
            jup.load(new InputStreamReader(inputUrl.openStream()));
            Enumeration<Object> keyset = jup.keys();
            while (keyset.hasMoreElements()) {
                String key = keyset.nextElement().toString();
                String val = jup.getProperty(key);
                if (delim != null) {
                    String[] components = key.split("\\" + delim);
                    if (debug) {
                        System.out.println("Key '" + key + "'  -->  " + Arrays.asList(components));
                    }
                    StringBuilder path = new StringBuilder();
                    JProperties jpp = jp;
                    for (int i = 0; i < components.length - 1; ++i) {
                        String keyComponent = components[i];
                        path.append(keyComponent + delim);
                        Object v = jpp.get(keyComponent);
                        if (v == null) {
                            JProperties njp = new JProperties();
                            jpp.put(keyComponent, (Object)njp);
                            jpp = njp;
                            continue;
                        }
                        if (v instanceof JProperties) {
                            jpp = (JProperties)v;
                            continue;
                        }
                        throw new Exception("Property at path -" + path + "' is a " + v);
                    }
                    jpp.put(components[components.length - 1], (Object)val);
                    continue;
                }
                jp.put(key, (Object)val);
            }
            if (outfilename != null) {
                File outfile = new File(outfilename);
                System.out.println("Writing to: " + outfile.getAbsolutePath());
                Parser.write(jp, new File(outfilename));
            } else {
                Parser.write(jp, new OutputStreamWriter(System.out));
                System.out.println("\n");
            }
        } else {
            JProperties jp = Parser.parse(inputUrl);
            if (outfilename != null) {
                File outfile = new File(outfilename);
                System.out.println("Writing to: " + outfile.getAbsolutePath());
                Parser.write(jp, new File(outfilename));
            } else {
                System.out.println(Parser.toJson(jp));
                System.out.println();
            }
        }
    }
}

