/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.jproperties.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JDK14LogConfig {
    public static boolean debug = false;
    static Log log = LogFactory.getLog(JDK14LogConfig.class);

    public static void startup() {
        System.out.println("Log is " + log.getClass().getName());
        LogManager logManager = LogManager.getLogManager();
        Logger logger = Logger.getLogger("");
        logger.removeHandler(logger.getHandlers()[0]);
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setFormatter(new LocalLogFormatter());
        consoleHandler.setLevel(Level.FINEST);
        logger.addHandler(consoleHandler);
        logger.setLevel(Level.ALL);
        if (debug) {
            Enumeration<String> loggers = logManager.getLoggerNames();
            while (loggers.hasMoreElements()) {
                String name = loggers.nextElement();
                Logger l = Logger.getLogger(name);
                System.out.println("   Loggger: " + name);
                System.out.println("          level: " + l.getLevel());
                System.out.println("       handlers: " + Arrays.asList(l.getHandlers()));
                System.out.println("       use parent?: " + l.getUseParentHandlers());
            }
        }
    }

    public static void main(String[] args) {
        debug = true;
        JDK14LogConfig.startup();
        log.debug((Object)"debug");
        log.info((Object)"info");
        log.warn((Object)"warn");
        log.error((Object)"error");
    }

    static class LocalLogFormatter
    extends Formatter {
        DateFormat df = new SimpleDateFormat("HH:mm:ss.SSS");

        LocalLogFormatter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String format(LogRecord record) {
            StringBuilder sb = new StringBuilder();
            DateFormat dateFormat = this.df;
            synchronized (dateFormat) {
                sb.append(this.df.format(new Date(record.getMillis())) + " ");
            }
            sb.append(record.getLevel() + " ");
            sb.append(record.getThreadID() + ":" + Thread.currentThread().getName() + " ");
            sb.append(LocalLogFormatter.shortLoggerName(record.getLoggerName() + " "));
            sb.append(record.getMessage());
            if (record.getThrown() != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintWriter pw = new PrintWriter(new OutputStreamWriter(baos));
                record.getThrown().printStackTrace(pw);
                pw.flush();
                sb.append("\n" + baos.toString());
            } else {
                sb.append("\n");
            }
            return sb.toString();
        }

        private static final String shortLoggerName(String loggerName) {
            return loggerName.substring(loggerName.lastIndexOf(".") + 1);
        }
    }
}

