/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.jproperties.substitution;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jmatrix.jproperties.JProperties;
import net.jmatrix.jproperties.util.ClassLogFactory;
import org.apache.commons.logging.Log;

public final class SubstitutionProcessor {
    public static Log log = ClassLogFactory.getLog();
    static final String TOKEN_REGEX = "\\$\\{[^\\$\\{\\}]+\\}";
    static final String COMPLETE_TOKEN_REGEX = "^\\$\\{[^\\$\\{\\}]+\\}$";
    static final Pattern PARTIAL_PATTERN = Pattern.compile("\\$\\{[^\\$\\{\\}]+\\}");
    static final Pattern COMPLETE_PATTERN = Pattern.compile("^\\$\\{[^\\$\\{\\}]+\\}$");
    public static int MAX_RECURSIVE_SUBSTITUTIONS = 10;
    public static boolean debug = false;

    public static final String processSubstitution(String s, JProperties p) {
        return (String)SubstitutionProcessor.processSubstitution(s, p, String.class);
    }

    public static final boolean containsTokens(String s) {
        Matcher matcher = PARTIAL_PATTERN.matcher(s);
        return matcher.find();
    }

    public static final Object processSubstitution(String s, JProperties p, Class returnType) {
        if (s == null || s.length() == 0) {
            return s;
        }
        return SubstitutionProcessor.processSubstitution(s, p, returnType, 0);
    }

    private static final boolean isCompleteToken(String s) {
        Matcher matcher = COMPLETE_PATTERN.matcher(s);
        return matcher.matches();
    }

    private static final Object processSubstitution(String s, JProperties p, Class returnType, int iter) {
        log.debug((Object)("processSubstitution(" + iter + ":" + s + "', to return type " + returnType + ")"));
        if (returnType == null) {
            returnType = Object.class;
        }
        if (returnType.equals(String.class)) {
            Object rval = SubstitutionProcessor.recursiveReplace(s, p, iter);
            if (rval == null) {
                return rval;
            }
            if (rval instanceof String) {
                return rval;
            }
            log.warn((Object)("processSubstitution called with String.class, but result is " + rval.getClass().getName()));
            return s;
        }
        if (SubstitutionProcessor.isCompleteToken(s)) {
            return SubstitutionProcessor.completeReplace(s, p, iter);
        }
        return SubstitutionProcessor.recursiveReplace(s, p, iter);
    }

    private static final Object completeReplace(String s, JProperties p, int iter) {
        log.debug((Object)("Complete replace of token '" + s + "', iter " + iter));
        SubstitutionToken subToken = new SubstitutionToken(s);
        String key = subToken.getKey();
        String def = subToken.getDefault();
        Object val = p.findValue(key);
        if (val == null) {
            return def;
        }
        if (val instanceof String) {
            String sval = (String)val;
            log.debug((Object)("Complete replace, result is string '" + sval + "'"));
            if (SubstitutionProcessor.containsTokens(sval)) {
                return SubstitutionProcessor.processSubstitution(sval, p, Object.class, iter);
            }
        }
        return val;
    }

    private static final Object recursiveReplace(String s, JProperties p, int iter) {
        log.debug((Object)("Recursive replace of token '" + s + "', iter " + iter));
        if (iter > MAX_RECURSIVE_SUBSTITUTIONS) {
            throw new RuntimeException("Error: recursive replacement limit on '" + s + "' " + iter + " exceeds max " + MAX_RECURSIVE_SUBSTITUTIONS);
        }
        Matcher matcher = PARTIAL_PATTERN.matcher(s);
        String newVal = s;
        while (matcher.find()) {
            log.debug((Object)("replace: found tokens in '" + s + "'"));
            String token = s.substring(matcher.start(), matcher.end());
            log.debug((Object)("   Token: '" + token + "'"));
            SubstitutionToken subToken = new SubstitutionToken(token);
            String key = subToken.getKey();
            String def = subToken.getDefault();
            String replaceVal = p.findString(key);
            if (replaceVal != null) {
                log.debug((Object)("   Found value for token " + token + ": " + replaceVal));
                newVal = newVal.replace(token, replaceVal);
                continue;
            }
            if (def == null) continue;
            log.debug((Object)("   No value for token " + token + ", using default: " + def));
            newVal = newVal.replace(token, def);
        }
        if (newVal.equals(s)) {
            return newVal;
        }
        return SubstitutionProcessor.processSubstitution(newVal, p, null, iter + 1);
    }

    static class SubstitutionToken {
        private String key = null;
        private String def = null;

        public SubstitutionToken(String s) {
            String tokenKey = s.substring(2, s.length() - 1);
            int pipeindex = tokenKey.indexOf("|");
            if (pipeindex != -1) {
                this.key = tokenKey.substring(0, pipeindex);
                this.def = tokenKey.substring(pipeindex + 1);
            } else {
                this.key = tokenKey;
            }
        }

        public String getKey() {
            return this.key;
        }

        public String getDefault() {
            return this.def;
        }
    }
}

