/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.jproperties.post;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jmatrix.jproperties.JProperties;
import net.jmatrix.jproperties.post.Options;
import net.jmatrix.jproperties.post.PostProcessor;
import net.jmatrix.jproperties.post.URLPropertiesLoader;
import net.jmatrix.jproperties.substitution.SubstitutionProcessor;
import net.jmatrix.jproperties.util.ClassLogFactory;
import org.apache.commons.logging.Log;

public class IncludePostProcessor
implements PostProcessor {
    static final Log log = ClassLogFactory.getLog();
    static String INCLUDE_REGEX = "^\\$\\[(.*)\\]$";
    static Pattern INCLUDE_PATTERN = Pattern.compile(INCLUDE_REGEX);

    public void post(JProperties p) {
        for (String key : p.keySet()) {
            Object ovalue = p.get(key);
            if (ovalue instanceof String) {
                String svalue = (String)ovalue;
                if (!Pattern.matches(INCLUDE_REGEX, svalue)) continue;
                log.debug((Object)(key + " include: " + svalue));
                Object included = IncludePostProcessor.include(svalue, p);
                if (included != null && included instanceof JProperties) {
                    ((JProperties)included).setParent(p);
                }
                p.put(key, included);
                continue;
            }
            if (!(ovalue instanceof JProperties)) continue;
            this.post((JProperties)ovalue);
        }
    }

    private static final Object include(String value, JProperties parent) {
        log.debug((Object)("include " + value));
        Matcher matcher = INCLUDE_PATTERN.matcher(value);
        matcher.matches();
        String include = matcher.group(1);
        log.debug((Object)("include: " + include));
        if (SubstitutionProcessor.containsTokens(include)) {
            include = SubstitutionProcessor.processSubstitution(include, parent);
            log.debug((Object)("Post Substitution: '" + include + "'"));
        }
        if (SubstitutionProcessor.containsTokens(include)) {
            throw new RuntimeException("Unresolvable Substitution in Include directive '" + include + "'");
        }
        String[] split = include.split("\\|");
        String url = split[0];
        String soptions = split.length > 1 ? split[1] : null;
        Options options = new Options(soptions);
        if (url.startsWith("method://")) {
            return IncludePostProcessor.includeMethodUrl(url, options);
        }
        URLPropertiesLoader upl = new URLPropertiesLoader();
        return upl.loadProperties(parent, url, options);
    }

    private static final JProperties includeMethodUrl(String url, Options options) {
        url = url.substring("method://".length());
        String className = url.substring(0, url.lastIndexOf("."));
        String methodName = url.substring(url.lastIndexOf(".") + 1);
        if (methodName.endsWith("()")) {
            methodName = methodName.substring(0, methodName.length() - 2);
        }
        try {
            Class<?> clazz = Class.forName(className);
            Method method = clazz.getMethod(methodName, new Class[0]);
            Object obj = method.invoke(null, new Object[0]);
            if (obj == null) {
                log.error((Object)("Method include of " + className + "." + methodName + " returned null."));
            }
            if (obj instanceof Map) {
                JProperties p = new JProperties((Map)obj);
                log.debug((Object)("Loaded " + p.size() + " properties with MethodLoader."));
                return p;
            }
            String m = "Error including " + url + ", don't know how to process result type " + obj.getClass().getName();
            if (options.failonerror) {
                throw new RuntimeException(m);
            }
            log.warn((Object)m);
        }
        catch (Exception ex) {
            String m = "Error processing " + url + " inclusion.";
            if (options.failonerror) {
                throw new RuntimeException(m, ex);
            }
            log.warn((Object)m);
        }
        return null;
    }
}

