/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.security;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import net.jlxxw.wechat.security.WeChatSecurityIpStore;
import net.jlxxw.wechat.util.LoggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class WeChatServerSecurityCheck {
    private static final Logger logger = LoggerFactory.getLogger(WeChatServerSecurityCheck.class);
    private WeChatSecurityIpStore weChatSecurityIpStore = null;
    @Autowired
    private ApplicationContext applicationContext;

    @PostConstruct
    private void init() {
        try {
            this.weChatSecurityIpStore = (WeChatSecurityIpStore)this.applicationContext.getBean(WeChatSecurityIpStore.class);
            Class clazz = this.weChatSecurityIpStore.getClass();
            if (AopUtils.isAopProxy((Object)this.weChatSecurityIpStore)) {
                clazz = AopUtils.getTargetClass((Object)this.weChatSecurityIpStore);
            }
            LoggerUtils.info(logger, "\u521d\u59cb\u5316\u5fae\u4fe1\u5b89\u5168ip\u5b58\u50a8\u5668\uff0c\u4f7f\u7528\u5916\u7f6e\u5b58\u50a8,{}", clazz.getName());
        }
        catch (NoSuchBeanDefinitionException e) {
            LoggerUtils.info(logger, "\u521d\u59cb\u5316\u5fae\u4fe1\u5b89\u5168ip\u5b58\u50a8\u5668\uff0c\u4f7f\u7528\u5185\u7f6e\u5b58\u50a8", new Object[0]);
            this.weChatSecurityIpStore = new WeChatSecurityIpStore(){
                private final Set<String> ipRangeWhitelist = new HashSet<String>();

                @Override
                public void addSecurityIpRange(String ipRange) {
                    this.ipRangeWhitelist.add(ipRange);
                }

                @Override
                public boolean isSecurityIp(String ip) {
                    boolean security = false;
                    for (String ipRange : this.ipRangeWhitelist) {
                        if (!WeChatServerSecurityCheck.inRange(ip, ipRange)) continue;
                        return true;
                    }
                    return security;
                }

                @Override
                public void addSecurityIpRange(List<String> ipRangeList) {
                    this.ipRangeWhitelist.addAll(ipRangeList);
                }
            };
        }
    }

    public boolean isSecurity(String requestIp) {
        return this.weChatSecurityIpStore.isSecurityIp(requestIp);
    }

    public void updateWeiXinServerIpRange(List<String> ipRangeList) {
        logger.info("\u66f4\u65b0ip\u767d\u540d\u5355\uff1a{}", ipRangeList);
        this.weChatSecurityIpStore.addSecurityIpRange(ipRangeList);
    }

    public static boolean inRange(String ip, String ipRange) {
        String cidrIp;
        String[] cidrIps;
        int cidrIpAddr;
        int type;
        int mask;
        String[] ips = ip.split("\\.");
        int ipAddr = Integer.parseInt(ips[0]) << 24 | Integer.parseInt(ips[1]) << 16 | Integer.parseInt(ips[2]) << 8 | Integer.parseInt(ips[3]);
        return (ipAddr & (mask = -1 << 32 - (type = Integer.parseInt(ipRange.replaceAll(".*/", ""))))) == ((cidrIpAddr = Integer.parseInt((cidrIps = (cidrIp = ipRange.replaceAll("/.*", "")).split("\\."))[0]) << 24 | Integer.parseInt(cidrIps[1]) << 16 | Integer.parseInt(cidrIps[2]) << 8 | Integer.parseInt(cidrIps[3])) & mask);
    }
}

