/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.schedul;

import java.time.LocalDateTime;
import net.jlxxw.wechat.exception.WeChatException;
import net.jlxxw.wechat.function.token.WeChatTokenManager;
import net.jlxxw.wechat.util.LoggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
@ConditionalOnProperty(prefix="we-chat", name={"enable-default-token-manager"}, havingValue="true")
public class ScheduledUpdateToken {
    private static final Logger logger = LoggerFactory.getLogger(ScheduledUpdateToken.class);
    private final WeChatTokenManager weChatTokenManager;

    public ScheduledUpdateToken(WeChatTokenManager weChatTokenManager) {
        this.weChatTokenManager = weChatTokenManager;
    }

    @Scheduled(cron="0 0/30 * * * ?")
    public void updateToken() throws WeChatException {
        String token = this.weChatTokenManager.getTokenFromWeiXin();
        this.weChatTokenManager.saveToken(token);
        LoggerUtils.info(logger, "\u66f4\u65b0token\u6210\u529f\uff0c\u5f53\u524d\u65f6\u95f4:{}", LocalDateTime.now());
        String ticket = this.weChatTokenManager.getJsApiTicketFromWeiXin();
        this.weChatTokenManager.saveJsApiTicket(ticket);
        LoggerUtils.info(logger, "\u66f4\u65b0jsApiTicket\u6210\u529f,\u5f53\u524d\u65f6\u95f4:{}", LocalDateTime.now());
    }
}

