/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.function.push;

import com.alibaba.fastjson.JSON;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import net.jlxxw.wechat.aop.check.group.Insert;
import net.jlxxw.wechat.component.BatchExecutor;
import net.jlxxw.wechat.dto.template.WeChatTemplateDTO;
import net.jlxxw.wechat.exception.ParamCheckException;
import net.jlxxw.wechat.exception.WeChatException;
import net.jlxxw.wechat.function.token.WeChatTokenManager;
import net.jlxxw.wechat.response.WeChatResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.client.RestTemplate;

@DependsOn(value={"weChatTokenManager"})
@Component
public class SyncPushTemplate {
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private BatchExecutor batchExecutor;
    @Autowired
    private WeChatTokenManager weChatTokenManager;

    public WeChatResponse pushTemplate(@Validated(value={Insert.class}) WeChatTemplateDTO template) throws ParamCheckException, WeChatException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String json = JSON.toJSONString((Object)template);
        HttpEntity request = new HttpEntity((Object)json, (MultiValueMap)headers);
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/message/template/send?access_token={0}", this.weChatTokenManager.getTokenFromLocal());
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
        String body = (String)responseEntity.getBody();
        WeChatResponse weChatResponse = (WeChatResponse)JSON.parseObject((String)body, WeChatResponse.class);
        if (!weChatResponse.isSuccessful()) {
            throw new WeChatException(weChatResponse);
        }
        return weChatResponse;
    }

    public List<WeChatResponse> pushTemplate(@Validated(value={org.apache.ibatis.annotations.Insert.class}) List<WeChatTemplateDTO> templateList) throws ParamCheckException {
        if (CollectionUtils.isEmpty(templateList)) {
            return new ArrayList<WeChatResponse>();
        }
        LinkedList<WeChatResponse> responseList = new LinkedList<WeChatResponse>();
        CountDownLatch countDownLatch = new CountDownLatch(templateList.size());
        this.batchExecutor.batchExecute(true, templateList, list -> {
            for (WeChatTemplateDTO weChatTemplate : list) {
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON);
                String json = JSON.toJSONString((Object)weChatTemplate);
                HttpEntity request = new HttpEntity((Object)json, (MultiValueMap)headers);
                String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/message/template/send?access_token={0}", this.weChatTokenManager.getTokenFromLocal());
                ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
                String body = (String)responseEntity.getBody();
                WeChatResponse weChatResponse = (WeChatResponse)JSON.parseObject((String)body, WeChatResponse.class);
                responseList.add(weChatResponse);
                countDownLatch.countDown();
            }
        });
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            return responseList;
        }
        return responseList;
    }
}

