/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.function.menu;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import javax.validation.constraints.NotBlank;
import net.jlxxw.wechat.aop.check.group.Insert;
import net.jlxxw.wechat.dto.menu.PersonalizedMenuDTO;
import net.jlxxw.wechat.exception.ParamCheckException;
import net.jlxxw.wechat.exception.WeChatException;
import net.jlxxw.wechat.function.token.WeChatTokenManager;
import net.jlxxw.wechat.response.WeChatResponse;
import net.jlxxw.wechat.response.menu.MatchPersonalizedMenuResponse;
import net.jlxxw.wechat.response.menu.PersonalizedMenuResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.client.RestTemplate;

@DependsOn(value={"weChatTokenManager"})
@Component
public class PersonalizedMenuManager {
    @Autowired
    private WeChatTokenManager weChatTokenManager;
    @Autowired
    private RestTemplate restTemplate;

    public PersonalizedMenuResponse createMenu(@Validated(value={Insert.class}) PersonalizedMenuDTO personalizedMenuDTO) throws WeChatException, ParamCheckException {
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/menu/addconditional?access_token={0}", this.weChatTokenManager.getTokenFromLocal());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity request = new HttpEntity((Object)JSON.toJSONString((Object)personalizedMenuDTO), (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
        String body = (String)responseEntity.getBody();
        PersonalizedMenuResponse response = (PersonalizedMenuResponse)JSONObject.parseObject((String)body, PersonalizedMenuResponse.class);
        if (!response.isSuccessful()) {
            throw new WeChatException(response);
        }
        return response;
    }

    public WeChatResponse deleteMenu(@NotBlank(message="\u83dc\u5355id\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u83dc\u5355id\u4e0d\u80fd\u4e3a\u7a7a") String menuId) throws WeChatException, ParamCheckException {
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/menu/delconditional?access_token={0}", this.weChatTokenManager.getTokenFromLocal());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("menuid", (Object)menuId);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity request = new HttpEntity((Object)jsonObject.toJSONString(), (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
        String body = (String)responseEntity.getBody();
        WeChatResponse response = (WeChatResponse)JSONObject.parseObject((String)body, WeChatResponse.class);
        if (!response.isSuccessful()) {
            throw new WeChatException(response);
        }
        return response;
    }

    public MatchPersonalizedMenuResponse tryMatch(@NotBlank(message="uid\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="uid\u4e0d\u80fd\u4e3a\u7a7a") String uid) throws WeChatException, ParamCheckException {
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/menu/trymatch?access_token={0}", this.weChatTokenManager.getTokenFromLocal());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("user_id", (Object)uid);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity request = new HttpEntity((Object)jsonObject.toJSONString(), (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
        String body = (String)responseEntity.getBody();
        MatchPersonalizedMenuResponse response = (MatchPersonalizedMenuResponse)JSONObject.parseObject((String)body, MatchPersonalizedMenuResponse.class);
        if (!response.isSuccessful()) {
            throw new WeChatException(response);
        }
        return response;
    }
}

