/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.component.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import javax.annotation.PostConstruct;
import net.jlxxw.wechat.component.netty.MetricsHandler;
import net.jlxxw.wechat.component.netty.WeChatChannel;
import net.jlxxw.wechat.properties.WeChatNettyServerProperties;
import net.jlxxw.wechat.util.LoggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WeChatCoreComponent {
    private static final ServerBootstrap BOOTSTRAP = new ServerBootstrap();
    private static final Logger logger = LoggerFactory.getLogger(WeChatCoreComponent.class);
    @Autowired
    private WeChatNettyServerProperties weChatNettyServerProperties;
    @Autowired
    private WeChatChannel weChatChannel;

    @PostConstruct
    public void postConstruct() {
        if (!this.weChatNettyServerProperties.getEnableNetty().booleanValue()) {
            return;
        }
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LoggerUtils.info(logger, "\u521d\u59cb\u5316 netty \u7ec4\u4ef6", new Object[0]);
                NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
                NioEventLoopGroup workGroup = new NioEventLoopGroup(WeChatCoreComponent.this.weChatNettyServerProperties.getMaxThreadSize().intValue());
                ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)BOOTSTRAP.group((EventLoopGroup)bossGroup, (EventLoopGroup)workGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                    protected void initChannel(SocketChannel socketChannel) throws Exception {
                        if (WeChatCoreComponent.this.weChatNettyServerProperties.isEnableMetrics()) {
                            socketChannel.pipeline().addLast(new ChannelHandler[]{new MetricsHandler()});
                        }
                        socketChannel.pipeline().addLast("http-decoder", (ChannelHandler)new HttpRequestDecoder());
                        LoggerUtils.debug(logger, "\u521d\u59cb\u5316 netty \u8bf7\u6c42\u89e3\u7801\u5668 \u6210\u529f", new Object[0]);
                        socketChannel.pipeline().addLast("http-aggregator", (ChannelHandler)new HttpObjectAggregator(WeChatCoreComponent.this.weChatNettyServerProperties.getHttpAggregatorMaxLength()));
                        LoggerUtils.debug(logger, "\u521d\u59cb\u5316 netty http\u805a\u5408\u5668 \u6210\u529f", new Object[0]);
                        socketChannel.pipeline().addLast("http-encoder", (ChannelHandler)new HttpResponseEncoder());
                        LoggerUtils.debug(logger, "\u521d\u59cb\u5316 netty \u54cd\u5e94\u7f16\u7801\u5668 \u6210\u529f", new Object[0]);
                        socketChannel.pipeline().addLast("http-chunked", (ChannelHandler)new ChunkedWriteHandler());
                        LoggerUtils.debug(logger, "\u521d\u59cb\u5316 netty \u5206\u5757\u5199\u5165\u5904\u7406\u7a0b\u5e8f \u6210\u529f", new Object[0]);
                        socketChannel.pipeline().addLast(new ChannelHandler[]{new ReadTimeoutHandler(WeChatCoreComponent.this.weChatNettyServerProperties.getChannelTimeout())});
                        if (WeChatCoreComponent.this.weChatNettyServerProperties.isEnableLog()) {
                            socketChannel.pipeline().addLast(new ChannelHandler[]{new LoggingHandler(LogLevel.INFO)});
                        }
                        socketChannel.pipeline().addLast("http-server", (ChannelHandler)WeChatCoreComponent.this.weChatChannel);
                        LoggerUtils.debug(logger, "\u521d\u59cb\u5316 netty \u5fae\u4fe1\u534f\u8bae\u5904\u7406\u5668 \u6210\u529f", new Object[0]);
                    }
                }).localAddress(WeChatCoreComponent.this.weChatNettyServerProperties.getNettyPort().intValue())).option(ChannelOption.SO_BACKLOG, (Object)WeChatCoreComponent.this.weChatNettyServerProperties.getQueueSize())).childOption(ChannelOption.SO_KEEPALIVE, (Object)false);
                try {
                    ChannelFuture future = BOOTSTRAP.bind(WeChatCoreComponent.this.weChatNettyServerProperties.getNettyPort().intValue()).sync();
                    LoggerUtils.info(logger, "\u5fae\u4fe1netty\u670d\u52a1\u542f\u52a8\uff0c\u5f00\u59cb\u76d1\u542c\u7aef\u53e3: {}", WeChatCoreComponent.this.weChatNettyServerProperties.getNettyPort());
                    future.channel().closeFuture().sync();
                }
                catch (InterruptedException e) {
                    LoggerUtils.error(logger, "\u5fae\u4fe1netty\u670d\u52a1\u542f\u52a8\u5931\u8d25\uff01\uff01\uff01", e);
                    System.exit(0);
                }
                finally {
                    bossGroup.shutdownGracefully();
                    workGroup.shutdownGracefully();
                }
            }
        };
        t.setName(this.weChatNettyServerProperties.getMainThreadName());
        t.setDaemon(false);
        t.start();
    }
}

