/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.function.ai;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import javax.validation.constraints.NotBlank;
import net.jlxxw.wechat.enums.AiBotEnvEnum;
import net.jlxxw.wechat.exception.ParamCheckException;
import net.jlxxw.wechat.exception.WeChatException;
import net.jlxxw.wechat.properties.WeChatAiBotProperties;
import net.jlxxw.wechat.response.ai.ChatResponse;
import net.jlxxw.wechat.response.ai.WeChatAiBotSignatureResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class AiBotFunction {
    private static final Logger logger = LoggerFactory.getLogger(AiBotFunction.class);
    @Autowired
    private WeChatAiBotProperties weChatAiBotProperties;
    @Autowired
    private RestTemplate restTemplate;

    public WeChatAiBotSignatureResponse signature(@NotBlank(message="\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a") String userId) throws WeChatException, ParamCheckException {
        String token = this.weChatAiBotProperties.getToken();
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new ParamCheckException("token \u4e0d\u80fd\u4e3a\u7a7a");
        }
        String url = "https://chatbot.weixin.qq.com/openapi/sign/" + token;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("userid", (Object)userId);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String json = jsonObject.toJSONString();
        HttpEntity request = new HttpEntity((Object)json, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
        String body = (String)responseEntity.getBody();
        logger.debug("ai bot signature,\u8bf7\u6c42\u5730\u5740:{},\u8bf7\u6c42\u53c2\u6570:{},\u8bf7\u6c42\u7ed3\u679c:{}", new Object[]{url, json, body});
        WeChatAiBotSignatureResponse weChatResponse = (WeChatAiBotSignatureResponse)JSON.parseObject((String)body, WeChatAiBotSignatureResponse.class);
        if (!weChatResponse.isSuccessful()) {
            throw new WeChatException(weChatResponse);
        }
        return weChatResponse;
    }

    public ChatResponse chat(@NotBlank(message="signature \u4e0d\u5e94\u8be5\u4e3a\u7a7a") @NotBlank(message="signature \u4e0d\u5e94\u8be5\u4e3a\u7a7a") String signature, @NotBlank(message="\u7528\u6237\u67e5\u8be2\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u7528\u6237\u67e5\u8be2\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a") String query, AiBotEnvEnum env, List<String> firstPrioritySkills, List<String> secondPrioritySkills) throws WeChatException, ParamCheckException {
        String token = this.weChatAiBotProperties.getToken();
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new ParamCheckException("token \u4e0d\u80fd\u4e3a\u7a7a");
        }
        String url = "https://chatbot.weixin.qq.com/openapi/aibot/" + token;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("query", (Object)query);
        jsonObject.put("signature", (Object)signature);
        if (env != null) {
            jsonObject.put("env", (Object)env.name().toLowerCase());
        }
        jsonObject.put("first_priority_skills", firstPrioritySkills);
        jsonObject.put("second_priority_skills", secondPrioritySkills);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String json = jsonObject.toJSONString();
        HttpEntity request = new HttpEntity((Object)json, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
        String body = (String)responseEntity.getBody();
        logger.debug("ai bot chat,\u8bf7\u6c42\u5730\u5740:{},\u8bf7\u6c42\u53c2\u6570:{},\u8bf7\u6c42\u7ed3\u679c:{}", new Object[]{url, json, body});
        ChatResponse weChatResponse = (ChatResponse)JSON.parseObject((String)body, ChatResponse.class);
        if (!weChatResponse.isSuccessful()) {
            throw new WeChatException(weChatResponse);
        }
        return weChatResponse;
    }
}

