/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.component.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.ServerChannel;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.SingleThreadEventExecutor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsHandler
extends ChannelDuplexHandler {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsHandler.class);
    private static final AtomicBoolean START_TASK = new AtomicBoolean(false);
    private static final AtomicLong CHANNEL_COUNT = new AtomicLong(0L);
    private static final AtomicLong TOTAL_READ_BYTES = new AtomicLong(0L);
    private static final AtomicLong TOTAL_WRITE_BYTES = new AtomicLong(0L);
    private static final ChannelGroup CHANNEL_GROUP = new DefaultChannelGroup((EventExecutor)ImmediateEventExecutor.INSTANCE);
    private static final ScheduledExecutorService statService = new ScheduledThreadPoolExecutor(1, r -> {
        Thread thread = new Thread(r);
        thread.setName("netty-metrics-thread");
        thread.setDaemon(false);
        return thread;
    });

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        CHANNEL_COUNT.incrementAndGet();
        if (START_TASK.compareAndSet(false, true)) {
            statService.scheduleAtFixedRate(() -> {
                LOG.info("----------------\u6027\u80fd\u6307\u6807\u91c7\u96c6\u5f00\u59cb-------------------");
                LOG.info("\u76ee\u524d\u5728\u7ebfChannel\u6570\uff1a" + CHANNEL_COUNT.get());
                for (EventExecutor eventExecutor : ctx.executor().parent()) {
                    SingleThreadEventExecutor executor = (SingleThreadEventExecutor)eventExecutor;
                    int size = executor.pendingTasks();
                    if (executor == ctx.executor()) {
                        LOG.info(ctx.channel() + ":" + executor + "\u5f85\u5904\u7406\u961f\u5217\u5927\u5c0f :  " + size);
                        continue;
                    }
                    LOG.info(executor + " \u5f85\u5904\u7406\u961f\u5217\u5927\u5c0f : " + size);
                }
                for (Channel channel : CHANNEL_GROUP) {
                    if (channel instanceof ServerChannel) continue;
                    LOG.info(channel + "\u53d1\u9001\u7f13\u5b58\u79ef\u538b\u5b57\u8282\u6570\uff1a" + channel.unsafe().outboundBuffer().totalPendingWriteBytes());
                }
                LOG.info("\u8bfb\u53d6\u901f\u7387(\u5b57\u8282/\u79d2)\uff1a" + TOTAL_READ_BYTES.getAndSet(0L));
                LOG.info("\u5199\u51fa\u901f\u7387(\u5b57\u8282/\u79d2)\uff1a" + TOTAL_WRITE_BYTES.getAndSet(0L));
                LOG.info("----------------\u6027\u80fd\u6307\u6807\u91c7\u96c6\u7ed3\u675f-------------------");
            }, 0L, 1L, TimeUnit.SECONDS);
        }
        CHANNEL_GROUP.add((Object)ctx.channel());
        super.channelActive(ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        int readableBytes = ((ByteBuf)msg).readableBytes();
        TOTAL_READ_BYTES.getAndAdd(readableBytes);
        ctx.fireChannelRead(msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        int writeableBytes = ((ByteBuf)msg).readableBytes();
        TOTAL_WRITE_BYTES.getAndAdd(writeableBytes);
        super.write(ctx, msg, promise);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        CHANNEL_COUNT.decrementAndGet();
        CHANNEL_GROUP.remove((Object)ctx.channel());
        super.channelInactive(ctx);
    }
}

